<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use DateTime; // Penting untuk perbandingan tanggal
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPenjualanPartsController extends AppController
{
    public $PhpExcel = null;

    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Penjualan Part';
        $data['titleMenu'] = 'Report Penjualan Part';

        if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');

            // Validasi input tanggal
            if (!$start || !$end || !strtotime($start) || !strtotime($end)) {
                $this->Flash->error(__('Tanggal tidak valid.'));
                return $this->redirect(['action' => 'index']);
            }

            try {
                $result = $conn->execute("
                    SELECT a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, 
                           (c.price * sub.total_qty * (1 - (c.diskon/100))) AS total_sales, c.total_harga, c.price, c.diskon, c.created
                    FROM workshops a 
                    LEFT JOIN (
                        SELECT workshop_id, partnumber, SUM(qty) as total_qty
                        FROM workshops_dtlparts
                        GROUP BY workshop_id, partnumber
                    ) sub ON a.id = sub.workshop_id
                    LEFT JOIN workshops_dtlparts c ON a.id = c.workshop_id AND sub.partnumber = c.partnumber
                    LEFT JOIN purchase_details pd ON c.partnumber = pd.partnumber
                    LEFT JOIN mst_employes e ON a.mekanik = e.employee_code
                    WHERE a.trans_date >= :start AND a.trans_date <= :end 
                        AND a.status != '1' 
                        AND c.status != '1'
                    GROUP BY a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, c.total_harga, c.price, c.diskon, c.created
                    ORDER BY a.trans_date ASC", ['start' => $start, 'end' => $end])->fetchAll('assoc');

                $pendapatanJasa = $conn->execute("
                    SELECT SUM(b.total_harga - b.diskon) AS jasa
                    FROM workshops a 
                    JOIN workshops_dtlservices b 
                    ON a.id = b.workshop_id
                    WHERE trans_date BETWEEN :start AND :end 
                        AND a.status != '1' 
                        AND b.status != '1'
                ", ['start' => $start, 'end' => $end])->fetch('assoc');

            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ' . $e->getMessage()));
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            foreach ($result as &$data) {
    $partnumber = $data['partnumber'];
    $transDate = $data['trans_date']; // Tanggal transaksi

    // Ambil harga beli yang berlaku pada tanggal transaksi
    $hpp = $conn->execute("
        SELECT h.harga_beli
        FROM part_price_history h
        WHERE h.partnumber = :partnumber
          AND h.valid_from <= :trans_date
          AND (h.valid_to IS NULL OR h.valid_to >= :trans_date)
        ORDER BY h.valid_from DESC
        LIMIT 1", ['partnumber' => $partnumber, 'trans_date' => $transDate])->fetch('assoc');

    if ($hpp) {
        $data['total_hpp'] = $data['total_qty'] * $hpp['harga_beli'];
    } else {
        // Jika tidak ada data historis, gunakan harga beli terbaru dari mst_parts
        $part = $conn->execute("
            SELECT harga_beli 
            FROM mst_parts 
            WHERE partnumber = :partnumber", ['partnumber' => $partnumber])->fetch('assoc');
        $data['total_hpp'] = $data['total_qty'] * ($part['harga_beli'] ?? 0);
    }

    $data['profit'] = $data['total_sales'] - $data['total_hpp'];
}

            $totalProfitPart = array_sum(array_column($result, 'profit'));
            $totalProfitJasa = $pendapatanJasa['jasa'];
            $totalProfit = $totalProfitPart + $totalProfitJasa;

            $company = [
                'name' => 'AHASS RAJAWALI PUTERA',
                'address' => 'Alamat Perusahaan'
            ];

            switch ($this->request->getData('type')) {
                case 'html':
                    $file = 'html';
                    break;
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            $this->set(compact('data', 'periode', 'company', 'result', 'totalProfitPart', 'totalProfitJasa', 'totalProfit'));
            $this->render($file);
        }

        $this->set(compact('data'));
    }
}