<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\I18n\FrozenDate;
use Cake\Log\Log;
use Cake\Datasource\Exception\InvalidPrimaryKeyException;
use Cake\Datasource\Exception\RecordNotFoundException;
use Cake\Database\Exception\SqlException;

class ReportNewCustomersController extends AppController
{
    public function index()
    {
        $Invoices = $this->getTableLocator()->get('Transactions.Invoices'); // Ganti 'Transactions.Invoices' dengan tabel yang sesuai
        $conn = $Invoices->getConnection();

        $startDate = $this->request->getData('startDate');
        $endDate = $this->request->getData('endDate');
        $type = $this->request->getData('type');

        $queryWhere = '';
        $queryParams = [];

        if ($startDate && $endDate) {
            try {
                $startDate = new FrozenDate($startDate);
                $endDate = new FrozenDate($endDate);

                $queryWhere = " AND w.trans_date BETWEEN :startDate AND :endDate";
                $queryParams['startDate'] = $startDate->format('Y-m-d'); // Format Y-m-d penting!
                $queryParams['endDate'] = $endDate->format('Y-m-d');     // Format Y-m-d penting!
            } catch (\Exception $e) {
                $this->Flash->error('Format tanggal tidak valid.');
                return $this->redirect(['action' => 'index']);
            }
        }

        $queries = [
            'newCustomers' => "
                SELECT w.nopol, w.type_mtr, MIN(w.trans_date) AS first_trans_date
                FROM workshops w
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM workshops w2
                    WHERE w2.nopol = w.nopol
                        AND w2.type_mtr = w.type_mtr
                        AND w2.trans_date < w.trans_date
                ) " . $queryWhere . "
                GROUP BY w.nopol, w.type_mtr
                ORDER BY first_trans_date",
            'dailyCustomers' => "
                SELECT DATE(w.trans_date) AS trans_date, COUNT(DISTINCT w.nopol, w.type_mtr) AS total_new_customers
                FROM workshops w
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM workshops w2
                    WHERE w2.nopol = w.nopol
                        AND w2.type_mtr = w.type_mtr
                ) " . $queryWhere . "
                GROUP BY DATE(w.trans_date)
                ORDER BY DATE(w.trans_date)",
            'monthlyCustomers' => "
                SELECT DATE_FORMAT(w.trans_date, '%Y-%m') AS trans_month, COUNT(DISTINCT w.nopol, w.type_mtr) AS total_new_customers
                FROM workshops w
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM workshops w2
                    WHERE w2.nopol = w.nopol
                        AND w2.type_mtr = w.type_mtr
                ) " . $queryWhere . "
                GROUP BY DATE_FORMAT(w.trans_date, '%Y-%m')
                ORDER BY DATE_FORMAT(w.trans_date, '%Y-%m')",
            'yearlyCustomers' => "
                SELECT YEAR(w.trans_date) AS trans_year, COUNT(DISTINCT w.nopol, w.type_mtr) AS total_new_customers
                FROM workshops w
                WHERE NOT EXISTS (
                    SELECT 1
                    FROM workshops w2
                    WHERE w2.nopol = w.nopol
                        AND w2.type_mtr = w.type_mtr
                ) " . $queryWhere . "
                GROUP BY YEAR(w.trans_date)
                ORDER BY YEAR(w.trans_date)",
        ];

        $data = [];

        foreach ($queries as $key => $query) {
            $data[$key] = $this->executeQuery($conn, $query, $queryParams);
        }

        if ($type === 'excel') {
            $this->set(compact('data', 'startDate', 'endDate'));
            $this->viewBuilder()->setClassName('Cake\View\XmlView');
            $this->response = $this->response->withType('application/vnd.ms-excel');
            $this->response = $this->response->withDownload('report_pelanggan_baru.xls');
            return;
        } elseif ($type === 'pdf') {
            $this->set(compact('data', 'startDate', 'endDate'));
            $this->viewBuilder()->setClassName('CakePdf.Pdf');
            $this->viewBuilder()->setOptions([
                'pdfConfig' => [
                    'orientation' => 'portrait',
                    'pageSize' => 'A4',
                    'margin' => [
                        'bottom' => 15,
                        'left' => 15,
                        'right' => 15,
                        'top' => 15
                    ]
                ]
            ]);
            return;
        } else {
            $this->set(compact('data', 'startDate', 'endDate'));
        }
    }

    private function executeQuery($conn, $query, $params)
    {
        try {
            $stmt = $conn->execute($query, $params); // Parameter di-bind di sini!
            $result = $stmt->fetchAll('assoc');
            debug(['Query' => $query, 'Params' => $params, 'Result' => $result]); // Debug tetap ada
            return $result;
        } catch (SqlException $e) {
            Log::error('SQL Error: ' . $e->getMessage() . ' Query: ' . $query . ' Params: ' . print_r($params, true)); // Log params
            $this->Flash->error('Terjadi kesalahan database. Silakan hubungi administrator.');
            return [];
        } catch (InvalidPrimaryKeyException $e) {
            Log::error('Primary Key Error: ' . $e->getMessage() . ' Query: ' . $query . ' Params: ' . print_r($params, true)); // Log params
            $this->Flash->error('Terjadi kesalahan data. Silakan hubungi administrator.');
            return [];
        } catch (RecordNotFoundException $e) {
            Log::warning('Data tidak ditemukan: ' . $e->getMessage() . ' Query: ' . $query . ' Params: ' . print_r($params, true)); // Log params
            $this->Flash->warning('Data tidak ditemukan.');
            return [];
        }
    }
}