<?php
declare(strict_types=1);

namespace Reports\Controller;

use App\Controller\AppController;
use PHPExcel;
use PHPExcel_IOFactory;

class ReportCustomerServiceController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {

        $data['titlePage'] = 'Report Konsumen Service';
        $data['titleMenu'] = 'Report Konsumen Service';
        if ($this->request->is('post')) {

            $startDate = $this->request->getData('startDate');
            $endDate = $this->request->getData('endDate');
            $periode = date('d/m/Y',strtotime($startDate)) .' - '.date('d/m/Y',strtotime($endDate)) ;
            $invoiceTable = $this->fetchTable('Transactions.Invoices');
            $result = $invoiceTable->find()
                      ->where(["trans_date between '".$startDate."' and '".$endDate."' " ])
                      ->all();
            $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
            $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
             if(empty($data)){
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
              } 
         
            switch ($this->request->getData('type')) {
                case 'html':
                  $file = 'html';
                  break;
                case 'excel':
                  $file = 'excel';
                  break;
                case 'pdf':
                  $file = 'pdf';
                  break;
                default:
                  $file = 'html';
                  break;
              }
             
              // $periode = date("F Y",strtotime($periode.'-01'));
              $this->set(compact('result','data','periode','company'));
              $this->render($file);  
        }
        $this->set(compact('data'));

    }



}
