<?php
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$fileName = 'report-stok.xlsx';
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

// Set company details
$sheet->mergeCells('A1:C1');
$sheet->mergeCells('A2:C2');
$sheet->setCellValue('A1', $company['name']);
$sheet->setCellValue('A2', $company['address']);
$sheet->setCellValue('A4', 'Report Harian Stok');
$sheet->setCellValue('A5', 'Tanggal');
$sheet->setCellValue('B5', $periode);

// Make the text in cells A1:B5 bold
$boldFont = ['font' => ['bold' => true]];
$sheet->getStyle('A1:A2')->applyFromArray($boldFont);
$sheet->getStyle('A4:A5')->applyFromArray($boldFont);
$sheet->getStyle('B5')->applyFromArray($boldFont);

// Set header row
$row = 8;
$sheet->setCellValue('A' . $row, 'Partnumber')
      ->setCellValue('B' . $row, 'Deskripsi')
      ->setCellValue('C' . $row, 'Qty');

// Apply styles to header row
$headerStyle = [
    'font' => ['bold' => true],
    'alignment' => ['horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER],
    'borders' => ['bottom' => ['borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN]],
];
$sheet->getStyle('A' . $row . ':C' . $row)->applyFromArray($headerStyle);

$row++;
$saldo = 0;
foreach ($data as $v) {
    $saldo += $v->qty;
    $sheet->setCellValue('A' . $row, $v->partnumber)
          ->setCellValue('B' . $row, $v->partdesc)
          ->setCellValue('C' . $row, $v->qty);
    $row++;
}

// Set column widths
foreach (range('A', 'C') as $columnID) {
    $sheet->getColumnDimension($columnID)->setAutoSize(true);
}

// Set title for the sheet
$sheet->setTitle('Laporan Stok Harian');

// Output the spreadsheet
$writer = new Xlsx($spreadsheet);
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment; filename="' . urlencode($fileName) . '"');
$writer->save('php://output');
exit;
?>