<?php
namespace MasterFile\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * RakSpareparts Controller
 *
 * @property \MasterFile\Model\Table\CustomersTable $RakSpareparts
 *
 * @method \MasterFile\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class RakSparepartsController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
      $query  = $this->RakSpareparts->find();
      if ($this->request->is('put')) {
            $cond = $this->__FilterSearch($this->request->data['filter']);
            $this->request->session()->write('Auth.Filter.Keyword',$cond);
      }
      $kondisi = $this->request->session()->read('Auth.Filter.Keyword');
      //dd($kondisi);
      if($kondisi){
        foreach($kondisi as $v){
          $query = $query->where( $v['conditions'][0] );
          foreach($v['bind'] as $j){
            $query=$query->bind($j[0],$j[1]);
          }
        }
      }
      if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
        $query = $query->order('RakSpareparts.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
      }else $query = $query->order('RakSpareparts.created desc');

      $rakspareparts = $this->paginate($query);
      $this->set(compact('rakspareparts'));
      $this->set('_serialize', ['rakspareparts']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $raksparepart = $this->RakSpareparts->get($id);

        $this->set('raksparepart', $raksparepart);
        $this->set('_serialize', ['raksparepart']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $this->loadComponent('General');
        $setStatus = 1;
        $raksparepart = $this->RakSpareparts->newEntity();
        $this->loadModel('MasterFile.Warehouses');
        $this->loadModel('MasterFile.Raks');
        $this->loadModel('MasterFile.Spareparts');
		if ($this->request->is('post')) {

            $connection = ConnectionManager::get('default');
            $connection->begin();

            //cek apakah sudah ada
            $cekSparepartRak = $this->RakSpareparts->find()->where(['partnumber'=>$this->request->getData('partnumber'),'rak'=>$this->request->getData('rak'),'warehouse_id'=>$this->request->getData('warehouse_id')])->first();
            if($cekSparepartRak){
                 $this->Flash->set(__('Data rak sparepart sudah diinputkan.'));
                 $this->redirect(['action' => 'add']);
            }

            $raksparepart = $this->RakSpareparts->patchEntity($raksparepart, $this->request->getData());
            $getWarehouse  = $this->Warehouses->get($raksparepart->warehouse_id);
			$raksparepart->branch_code = $getWarehouse->branch_code;
			$raksparepart->branch_id = $getWarehouse->branch_id;
			$raksparepart->warehouse_code = $getWarehouse->kode_gudang;
            $raksparepart->create_by = $this->request->session()->read('Auth.User.id');
            $raksparepart->modi_by = $this->request->session()->read('Auth.User.id');

            $getRaks  = $this->Raks->find()->where(['rak_code'=>$raksparepart->rak,'warehouse_id'=>$raksparepart->warehouse_id])->first();
            $raksparepart->rak_id = $getRaks->id;

            $getPartnumber  = $this->Spareparts->find()->where(['partnumber'=>$raksparepart->partnumber])->first();
            $raksparepart->part_id = $getPartnumber->id;

            if ($this->RakSpareparts->save($raksparepart)) {
                $setStatus = 1;
                $message = 'The raksparepart has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The raksparepart could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'add']);
            }else {
                $connection->rollback();
            }
        }

        
		$warehouses = $this->Warehouses->find('list',[
                'keyField' => 'id',
                'valueField' => 'nama_gudang'
            ])->toArray();
        $this->set(compact('raksparepart','warehouses'));
        $this->set('_serialize', ['raksparepart','warehouses']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $raksparepart = $this->RakSpareparts->get($id);
		$this->loadModel('MasterFile.Warehouses');
        $this->loadModel('MasterFile.Raks');
        $this->loadModel('MasterFile.Spareparts');
        if ($this->request->is(['patch', 'post', 'put'])) {
             $connection = ConnectionManager::get('default');
            $connection->begin();
            $raksparepart = $this->RakSpareparts->patchEntity($raksparepart, $this->request->getData());
            $getWarehouse  = $this->Warehouses->get($raksparepart->warehouse_id);
            $raksparepart->branch_code = $getWarehouse->branch_code;
            $raksparepart->branch_id = $getWarehouse->branch_id;
            $raksparepart->warehouse_code = $getWarehouse->kode_gudang;
            $raksparepart->create_by = $this->request->session()->read('Auth.User.id');
            $raksparepart->modi_by = $this->request->session()->read('Auth.User.id');

            $getRaks  = $this->Raks->find()->where(['rak_code'=>$raksparepart->rak,'warehouse_id'=>$raksparepart->warehouse_id])->first();
            $raksparepart->rak_id = $getRaks->id;

            $getPartnumber  = $this->Spareparts->find()->where(['partnumber'=>$raksparepart->partnumber])->first();
            $raksparepart->part_id = $getPartnumber->id;

            if ($this->RakSpareparts->save($raksparepart)) {
                $setStatus = 1;
                $message = 'The raksparepart has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The raksparepart could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'edit/'.$id]);
            }else {
                $connection->rollback();
            }
        }
		
		$warehouses = $this->Warehouses->find('list',[
                'keyField' => 'id',
                'valueField' => 'nama_gudang'
            ])->toArray();
        $this->set(compact('raksparepart','warehouses'));
        $this->set('_serialize', ['raksparepart']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function delete($id = null)
     {
         $this->request->allowMethod(['post', 'delete']);
         $connection = ConnectionManager::get('default');
         $connection->begin();
         if(isset($this->request->data['id'])){
             $ids = explode(',',$this->request->data['id']);
         }else $ids = $id;

         foreach($ids as $i=>$v){
           $raksparepart = $this->RakSpareparts->get($v);
           if ($this->RakSpareparts->delete($raksparepart,[
             'dependent' => true,
             'cascadeCallbacks' => true
             ])) {
               $setStatus=1;
               $message = 'The raksparepart has been deleted.';
           } else {
               $setStatus=0;
               $message = 'The raksparepart with id: '.$v.' could not be deleted. Please, try again.';
               break;
           }
         }

         $this->Flash->error(__($message));
         if($setStatus){
             $connection->commit();
         }else {
             $connection->rollback();
         }
         return $this->redirect(['action' => 'index']);
     }
}
