<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * Employees Controller
 *
 * @property \Masters\Model\Table\CustomersTable $Employees
 *
 * @method \Masters\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class EmployeesController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Mekanik';
        $data['titleMenu'] = 'Data Mekanik';


        $query = $this->Employees->find('all')->contain(['Jabatans']);

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'employee_code LIKE' => '%' . $search . '%',
                    'nama_mekanik LIKE' => '%' . $search . '%'
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Employees.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Employees.created desc');
        
        $employees = $this->paginate($query);

      $this->set(compact('employees','data'));
      $this->set('_serialize', ['employees']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $employee = $this->Employees->get($id);

        $this->set('employee', $employee);
        $this->set('_serialize', ['employee']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Mekanik';
        $data['titleMenu'] = 'Data Mekanik';
       // $this->loadComponent('General');
        $setStatus = 1;
        $employee = $this->Employees->newEmptyEntity();
        if ($this->request->is('post')) {
            //$this->loadComponent('General');
            $this->loadComponent('General');
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $employee = $this->Employees->patchEntity($employee, $this->request->getData());
            $employee->employee_code=$this->General->__sinchronizeID('EM',date('ym'),4,array('val_id','val_char', 'val_value'));
            $employee->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $employee->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            // dd($employee);
            if ($this->Employees->save($employee)) {
                $setStatus = 1;
                $message = 'The employee has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The employee could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }

        $JabatanModel = $this->fetchTable('Masters.Jabatans');
        $jabatans = $JabatanModel
                    ->find('list',
                        keyField : 'id',
                        valueField : 'nama_jabatan'
                    )
                    ->toArray();

        $this->set(compact('employee','jabatans','data'));
        $this->set('_serialize', ['employee','jabatans']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Mekanik';
        $data['titleMenu'] = 'Data Mekanik';
        $employee = $this->Employees->get($id);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $employee = $this->Employees->patchEntity($employee, $this->request->getData());
            $employee->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $employee->modi_by = $this->getRequest()->getSession()->read('Auth.id');
			//dd($employee);
            if ($this->Employees->save($employee)) {
                $setStatus = 1;
                $message = 'The employee has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The employee could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        $JabatanModel = $this->fetchTable('Masters.Jabatans');
        $jabatans = $JabatanModel
                    ->find('list',
                        keyField : 'id',
                        valueField : 'nama_jabatan'
                    )
                    ->toArray();
        $this->set(compact('employee','jabatans','data'));
        $this->set('_serialize', ['employee','jabatans']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function delete($id = null)
     {
         $this->request->allowMethod(['post', 'delete']);
         $connection = ConnectionManager::get('default');
         $connection->begin();
         if(isset($this->request->data['id'])){
             $ids = explode(',',$this->request->data['id']);
         }else $ids = $id;

         foreach($ids as $i=>$v){
           $employee = $this->Employees->get($v);
           if ($this->Employees->delete($employee,[
             'dependent' => true,
             'cascadeCallbacks' => true
             ])) {
               $setStatus=1;
               $message = 'The employee has been deleted.';
           } else {
               $setStatus=0;
               $message = 'The employee with id: '.$v.' could not be deleted. Please, try again.';
               break;
           }
         }

         $this->Flash->error(__($message));
         if($setStatus){
             $connection->commit();
         }else {
             $connection->rollback();
         }
         return $this->redirect(['action' => 'index']);
     }
}
