<?php
declare(strict_types=1);

namespace UserPriviledges\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Users Model
 *
 * @property \UserPriviledges\Model\Table\ApprovalUsersTable&\Cake\ORM\Association\HasMany $ApprovalUsers
 * @property \UserPriviledges\Model\Table\UserProfilesTable&\Cake\ORM\Association\HasMany $UserProfiles
 * @property \UserPriviledges\Model\Table\GroupsTable&\Cake\ORM\Association\BelongsToMany $Groups
 *
 * @method \UserPriviledges\Model\Entity\User newEmptyEntity()
 * @method \UserPriviledges\Model\Entity\User newEntity(array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\User[] newEntities(array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\User get($primaryKey, $options = [])
 * @method \UserPriviledges\Model\Entity\User findOrCreate($search, ?callable $callback = null, $options = [])
 * @method \UserPriviledges\Model\Entity\User patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\User[] patchEntities(iterable $entities, array $data, array $options = [])
 * @method \UserPriviledges\Model\Entity\User|false save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \UserPriviledges\Model\Entity\User saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \UserPriviledges\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface|false saveMany(iterable $entities, $options = [])
 * @method \UserPriviledges\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface saveManyOrFail(iterable $entities, $options = [])
 * @method \UserPriviledges\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface|false deleteMany(iterable $entities, $options = [])
 * @method \UserPriviledges\Model\Entity\User[]|\Cake\Datasource\ResultSetInterface deleteManyOrFail(iterable $entities, $options = [])
 *
 * @mixin \Cake\ORM\Behavior\TimestampBehavior
 */
class UsersTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('users');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

         $this->belongsToMany('Groups', [
             'className'=>'UserPriviledges.Groups',
             'joinTable' => 'groups_users',
             'foreignKey' => 'user_id',
             'associationForeignKey' => 'group_id',
        ]);

        $this->belongsToMany('Branches', [
            'className'=>'UserPriviledges.Branches',
             'joinTable' => 'branches_users',
             'foreignKey' => 'user_id',
             'associationForeignKey' => 'branch_id',
        ]);

        $this->belongsToMany('Regions', [
            'className'=>'UserPriviledges.Regions',
             'joinTable' => 'regions_users',
             'foreignKey' => 'user_id',
             'associationForeignKey' => 'region_id',
        ]);


    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        
        $validator
            ->scalar('name')
            ->maxLength('name', 60)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->scalar('username')
            ->maxLength('username', 60)
            ->requirePresence('username', 'create')
            ->notEmptyString('username')
            ->add('username', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);

        $validator
            ->scalar('password')
            ->maxLength('password', 255)
            ->requirePresence('password', 'create')
            ->notEmptyString('password');

        $validator
            ->email('email')
            ->requirePresence('email', 'create')
            ->notEmptyString('email')
            ->add('email', 'unique', ['rule' => 'validateUnique', 'provider' => 'table']);




        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['username']), ['errorField' => 'username']);
        $rules->add($rules->isUnique(['email']), ['errorField' => 'email']);

        return $rules;
    }


}
