<?php
declare(strict_types=1);

namespace Transactions\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class BillingInvoiceItemsTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('billing_invoice_items');
        $this->setDisplayField('description');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->belongsTo('BillingInvoices', [
            'foreignKey' => 'billing_invoice_id',
            'className' => 'Transactions.BillingInvoices',
        ]);
    }

    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('description')
            ->requirePresence('description', 'create')
            ->notEmptyString('description');

        $validator
            ->decimal('quantity')
            ->notEmptyString('quantity');

        $validator
            ->decimal('unit_price')
            ->notEmptyString('unit_price');

        return $validator;
    }
}