<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;
use Mpdf\Mpdf;
class InvoicesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $listpayment = ['Cash', 'QRIS', 'Transfer Bank', 'EDC/CARD', 'Piutang'];
        $data['titlePage'] = 'Faktur Penjualan';
        $data['titleMenu'] = 'List Data Faktur Penjualan';

        $this->paginate = [
            'limit' => 20,
            'order' => [
                'created' => 'desc',
            ],
        ];

        $query = $this->Invoices->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
            'OR' => [
                'kode_workshop LIKE' => '%' . $search . '%',
                'nopol LIKE' => '%' . $search . '%',
                'nama LIKE' => '%' . $search . '%',
                'trans_date' => $search,
            ]
        ]);
        }

        $invoice = $this->paginate($query);

        $this->set(compact('data', 'invoice', 'listpayment'));
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
       public function view($id = null)
    
{
    $listpayment = ['Cash', 'QRIS', 'Transfer Bank', 'EDC/CARD', 'Piutang'];
    $CorporateTable = $this->fetchTable('Masters.Corporates');
    $corporates = $CorporateTable
                    ->find('list', [
                        'keyField' => 'id',
                        'valueField' => 'name'
                    ])
                    ->toArray();
    $corporate = $corporates;
    $corporate += ['Other' => 'Other'];

    $CompaniesTable = $this->fetchTable('SystemConfigurations.Companies');
    $companies = $CompaniesTable->find()->first();

    $Employees = $this->fetchTable('Masters.Employees');
    $mekanik = $Employees
                ->find('list', [
                    'keyField' => 'employee_code',
                    'valueField' => 'nama_mekanik'
                ])
                ->toArray();
    $data['titlePage'] = 'Faktur Penjualan';
    $data['titleMenu'] = 'View Data Faktur Penjualan';
    $invoice = $this->Invoices->get($id, [
        'contain' => ['InvoiceJasas', 'InvoiceParts']
    ]);

    $this->set(compact('data', 'invoice', 'listpayment', 'corporate', 'companies', 'mekanik'));
}

    public function prints($id = null)
    {
        $listpayment = ['Cash','QRIS','Transfer Bank','EDC/CARD','Piutang'];            
        $CorporateTable = $this->fetchTable('Masters.Corporates');
        $corporates = $CorporateTable
                    ->find('list',
                        keyField : 'id',
                        valueField : 'name'
                    )
                    ->toArray();
        $corporate = $corporates   ;         
        $corporate +=['Other'=>'Other']; 




        $CompaniesTable = $this->fetchTable('SystemConfigurations.Companies');
        $companies = $CompaniesTable->find()->first();

        $Employees = $this->fetchTable('Masters.Employees');
        $mekanik = $Employees
                    ->find('list',
                        keyField : 'employee_code',
                        valueField : 'nama_mekanik'
                    )
                    ->toArray();


        $this->viewBuilder()->setLayout('print_css');
        $data['titlePage'] = 'Faktur Penjualan';
        $data['titleMenu'] = 'View Data Faktur Penjualan';
        $invoice = $this->Invoices->get($id, contain: ['InvoiceJasas','InvoiceParts']);
        $this->set(compact('data','invoice','companies','mekanik','corporate','listpayment'));
    }
    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    /**
 * Add method
 *
 * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
 */
public function add()
{
    $data['titlePage'] = 'Faktur Penjualan';
    $data['titleMenu'] = 'Add Data Faktur Penjualan';
    $this->loadComponent('General');
    $setStatus = 1;
    $invoice = $this->Invoices->newEmptyEntity();
    $CorporateTable = $this->fetchTable('Masters.Corporates');
    
    if($this->request->is('post')){
        $connection = ConnectionManager::get('default');
        $connection->begin();
        
        $invoice = $this->Invoices->patchEntity($invoice, $this->request->getData());
        
        // ===== PERBAIKAN DIMULAI DARI SINI =====
        // Simpan perusahaan baru jika user pilih 'Other'
        if($invoice->corporate_id == 'Other'){
            $entCorporate = $CorporateTable->newEmptyEntity();
            $entCorporate->name = $invoice->corporate_name;
            $entCorporate->discount_part = 10;
            $entCorporate->discount_jasa = 10;
            $entCorporate->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $entCorporate->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            
            if($CorporateTable->save($entCorporate)){
                // Set corporate_id dengan ID perusahaan yang baru disimpan
                $invoice->corporate_id = $entCorporate->id;
            } else {
                $setStatus = 0;
                $message = 'Fail add perusahaan. Please, try again.';
            }
        } else if(empty($invoice->corporate_id) || $invoice->corporate_id == ''){
            // Set null jika tidak ada perusahaan dipilih
            $invoice->corporate_id = null;
        }
        // ===== PERBAIKAN SELESAI =====
        
        $invoice->kode_workshop=$this->General->__sinchronizeID('INV',date('ym'),5,array('val_id','val_char', 'val_value'));
        $invoice->create_by = $this->getRequest()->getSession()->read('Auth.id');
        $invoice->modi_by = $this->getRequest()->getSession()->read('Auth.id');
        $invoice->trans_date=$this->request->getData('trans_date');
        $invoice->total=$this->General->__sinchronizecurrency($this->request->getData('total'));
        $invoice->disc=$this->General->__sinchronizecurrency($this->request->getData('disc'));
        $invoice->grand_total=$this->General->__sinchronizecurrency($this->request->getData('grand_total'));
        
        //cek customer by nomor polisi, jika tidak ada disimpan
        $customersTable = $this->fetchTable('Masters.Customers');
        $cekCustomer = $customersTable->find()->where(['nopol'=>$invoice->nopol])->first();
        
        if(!$cekCustomer){
            $entCustomer = $customersTable->newEmptyEntity();
            $entCustomer->nopol = $invoice->nopol;
            $entCustomer->kilometer = $invoice->kilometer;
            $entCustomer->nama = $invoice->nama;
            $entCustomer->no_tlp = $invoice->no_tlp;
            // ✅ TAMBAHKAN BARIS INI:
    $entCustomer->corporate_id = $invoice->corporate_id;
            
            if($invoice->corporate_id){
                $entCustomer->type_customer = '1';
            }else{
                $entCustomer->type_customer = '';
            }
            
            $entCustomer->diskon = $invoice->diskon;
            $entCustomer->create_by = $invoice->create_by;
            $entCustomer->modi_by = $invoice->modi_by;
            
            if(!$customersTable->save($entCustomer)){
                $setStatus = 0;
                $message = 'Fail add customer. Please, try again.';
            }
        }
        
        $invoice->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');
        $invoice->branch_id= $this->getRequest()->getSession()->read('Auth.branch_id');
        
        $total=0;
        $qty=0;
        $j=0;
        
        // Process invoice jasas
        if($invoice->invoice_jasas){
            foreach ($invoice->invoice_jasas as $i => $v) {
                if($v->kode_jasa != ''){
                    $invoice->invoice_jasas[$i]->pkb_no = $invoice->kode_workshop;
                    $invoice->invoice_jasas[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $invoice->invoice_jasas[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                    $invoice->invoice_jasas[$i]->created = date("Y-m-d H:i:s");
                    $invoice->invoice_jasas[$i]->modified = date("Y-m-d H:i:s");
                    $invoice->invoice_jasas[$i]->harga = $this->General->__sinchronizecurrency($invoice->invoice_jasas[$i]->harga);
                    $invoice->invoice_jasas[$i]->diskon = $this->General->__sinchronizecurrency($invoice->invoice_jasas[$i]->diskon);
                    $invoice->invoice_jasas[$i]->total_harga = $this->General->__sinchronizecurrency($invoice->invoice_jasas[$i]->total_harga);
                    $invoice->invoice_jasas[$i]->branch_code = $invoice->branch_code;
                    $invoice->invoice_jasas[$i]->branch_id = $invoice->branch_id;
                }else{
                    unset($invoice->invoice_jasas[$i]);
                }
            }
        }
        
        // Process invoice parts
        if($invoice->invoice_parts){
            $transLog = [];
            foreach ($invoice->invoice_parts as $i => $v) {
                if($v->partnumber !=''){
                    $invoice->invoice_parts[$i]->pkb_no = $invoice->kode_workshop;
                    $invoice->invoice_parts[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $invoice->invoice_parts[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                    $invoice->invoice_parts[$i]->created = date("Y-m-d h:i:s");
                    $invoice->invoice_parts[$i]->modified = date("Y-m-d h:i:s");
                    $invoice->invoice_parts[$i]->price = $this->General->__sinchronizecurrency($invoice->invoice_parts[$i]->price);
                    $invoice->invoice_parts[$i]->diskon = $this->General->__sinchronizecurrency($invoice->invoice_parts[$i]->diskon);
                    $invoice->invoice_parts[$i]->total_harga = $this->General->__sinchronizecurrency($invoice->invoice_parts[$i]->total_harga);
                    $invoice->invoice_parts[$i]->branch_code = $invoice->branch_code;
                    $invoice->invoice_parts[$i]->branch_id = $invoice->branch_id;
                    
                    $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['kode_gudang'=>$v->warehouse_code])->select(['id'])->first();
                    $invoice->invoice_parts[$i]->warehouse_id = $getwarehouseID->id;
                    
                    $getrakID = $this->fetchTable('Masters.Raks')->find()->where(['rak_code'=>$v->rak_code])->select(['id'])->first();
                    $invoice->invoice_parts[$i]->rak_id = $getrakID->id;
                    
                    $getPartsname = $this->fetchTable('Masters.Parts')->find()->where(['partnumber'=>$v->partnumber])->select(['deskripsi'])->first();
                    $invoice->invoice_parts[$i]->partdesc = $getPartsname->deskripsi;
                    
                    $transLog[$i]['trx_code'] = $invoice->kode_workshop;
                    $transLog[$i]['trx_date'] = date('Y-m-d H:i:s');
                    $transLog[$i]['part_no'] = $v->partnumber;
                    $transLog[$i]['part_name'] = $getPartsname->deskripsi;
                    $transLog[$i]['in_out'] = 'O';
                    $transLog[$i]['qty'] = $v->qty;
                    $transLog[$i]['warehouse_code'] = $v->warehouse_code;
                    $transLog[$i]['warehouse_id'] = $getwarehouseID->id;
                    $transLog[$i]['rak_code'] = $v->rak_code;
                    $transLog[$i]['rak_id'] = $getrakID->id;
                    $transLog[$i]['branch_code'] = $invoice->branch_code;
                    $transLog[$i]['branch_id'] = $invoice->branch_id;
                }else{
                    unset($invoice->invoice_parts[$i]);
                }
            }
        }
        
        if($setStatus){
            if ($this->Invoices->save($invoice,[ 'associated' => ['InvoiceParts','InvoiceJasas']])) {
                $setStatus = 1;
                $message = 'The data has been saved.';
                
                if($transLog){
                    $logpartTable = $this->fetchTable('Transactions.LogParts');
                    $logs = $logpartTable->newEntities($transLog);
                    $resulLogs = $logpartTable->saveMany($logs);
                    
                    if($resulLogs){
                        //update stok
                        $parttable = $this->fetchTable('Transactions.StockParts');
                        foreach ($transLog as $i => $v) {
                            $getStocks = $parttable->find()->where(['partnumber'=>$v['part_no'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                            
                            if($getStocks->qty >= $v['qty'] ){
                                $getStocks->qty = $getStocks->qty - $v['qty'];
                                if(!$parttable->save($getStocks)){
                                    $setStatus = 0;
                                    $message = 'Fail update stocks. Please, try again.';
                                    break;
                                }else{
                                    $setStatus = 1;
                                    $message = 'The data has been saved.';
                                }
                            } else{
                                $setStatus = 0;
                                $message = 'Qty requset over from qty stock. Please, try again.';
                                break;
                            }
                        }
                    }else{
                        $setStatus = 0;
                        $message = 'The log parts could not be saved. Please, try again.';
                    }
                }
            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }
        }else{
            $setStatus = 0;
            if(isset($message)) $message=$message;
            else $message = 'Saldo stock tidak memenuhi.';
        }
        
        if($setStatus){
            $connection->commit();
            $message = 'The data has been saved.';
            $this->Flash->set(__($message));
            return $this->redirect(['action' => 'index']);
        }else {
            $this->Flash->set(__($message));
            $connection->rollback();
        }
    }
    
    $corporates = $CorporateTable
        ->find('list',[
            'keyField' => 'id',
            'valueField' => 'name'
        ])
        ->toArray();
    $corporate = $corporates ;
    $corporate +=['Other'=>'Other'];
    
    $Employees = $this->fetchTable('Masters.Employees');
    $mekanik = $Employees
        ->find('list',[
            'keyField' => 'employee_code',
            'valueField' => 'nama_mekanik'
        ])
        ->toArray();
    
    $Motors = $this->fetchTable('Masters.Motorcycles');
    $tipemtr = $Motors
        ->find('list',[
            'keyField' => 'type_mtr',
            'valueField' => 'type_mtr'
        ])
        ->order(['type_mtr'=>'asc'])
        ->toArray();
    
    $listpayment = ['Cash','QRIS','Transfer Bank','EDC/CARD','Piutang'];
    $this->set(compact('data','mekanik','invoice','corporate','listpayment','tipemtr'));
}


    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function edit($id)
{
    $data['titlePage'] = 'Faktur Penjualan';
    $data['titleMenu'] = 'Edit Data Faktur Penjualan';
    $this->loadComponent('General');
    $setStatus = 1;
    $invoice = $this->Invoices->get($id,
        contain : ['InvoiceJasas','InvoiceParts']
    );
    
    // Store the original trans_date before patching
    $originalTransDate = $invoice->trans_date;
    
    if($this->request->is('put')){
        $connection = ConnectionManager::get('default');
        $connection->begin();
        $invoice = $this->Invoices->patchEntity($invoice, $this->request->getData());
        // Set default value untuk corporate_id jika kosong atau 'Other'
if(empty($invoice->corporate_id) || $invoice->corporate_id == 'Other' || $invoice->corporate_id == ''){
    $invoice->corporate_id = null;
}

        
        // Restore the original trans_date to prevent it from being updated or set to NULL
        $invoice->trans_date = $originalTransDate;

        $invoice->modi_by = $this->getRequest()->getSession()->read('Auth.id');
        $invoice->modified = date('Y-m-d H:i:s');

        $invoice->branch_code='01';
        $invoice->branch_id= '1';

        //cek customer by nomor polisi, jika tidak ada disimpan
        $customersTable = $this->fetchTable('Masters.Customers');
        $cekCustomer = $customersTable->find()->where(['nopol'=>$invoice->nopol])->first();
        if(!$cekCustomer){
    $entCustomer = $customersTable->newEmptyEntity();
    $entCustomer->nopol = $invoice->nopol;
    $entCustomer->kilometer = $invoice->kilometer;
    $entCustomer->nama = $invoice->nama;
    $entCustomer->no_tlp = $invoice->no_tlp;
    
    // ✅ TAMBAHKAN: Set corporate_id untuk customer
    $entCustomer->corporate_id = $invoice->corporate_id; // bisa null atau ID perusahaan
    
    if($invoice->corporate_id){
        $entCustomer->type_customer = '1';
    }else{
        $entCustomer->type_customer = '';
    }
    
    $entCustomer->diskon = $invoice->diskon;
    $entCustomer->create_by = $invoice->create_by;
    $entCustomer->modi_by = $invoice->modi_by;
    
    if(!$customersTable->save($entCustomer)){
        $setStatus = 0;
        $message = 'Fail add customer. Please, try again.';
    }
}


        $total=0;
        $qty=0;
        $j=0;
        if($invoice->invoice_jasas){
            foreach ($invoice->invoice_jasas as $i => $v) {
                if($v->kode_jasa != ''){
                    $invoice->invoice_jasas[$i]->pkb_no = $invoice->kode_workshop;
                    $invoice->invoice_jasas[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $invoice->invoice_jasas[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                    $invoice->invoice_jasas[$i]->created = date("Y-m-d H:i:s");
                    $invoice->invoice_jasas[$i]->modified = date("Y-m-d H:i:s");
                    $invoice->invoice_jasas[$i]->harga = $this->General->__sinchronizecurrency($invoice->invoice_jasas[$i]->harga);

                    $invoice->invoice_jasas[$i]->diskon = $this->General->__sinchronizecurrency($invoice->invoice_jasas[$i]->diskon);
                    $invoice->invoice_jasas[$i]->total_harga = $this->General->__sinchronizecurrency($invoice->invoice_jasas[$i]->total_harga);

                    $invoice->invoice_jasas[$i]->branch_code = $invoice->branch_code;
                    $invoice->invoice_jasas[$i]->branch_id = $invoice->branch_id;
                }else{
                    unset($invoice->invoice_jasas[$i]);
                }
            }
        }

        if($invoice->invoice_parts){
          foreach ($invoice->invoice_parts as $i => $v) {
            if($v->partnumber !=''){
                $invoice->invoice_parts[$i]->pkb_no = $invoice->kode_workshop;
                $invoice->invoice_parts[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                $invoice->invoice_parts[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                $invoice->invoice_parts[$i]->created = date("Y-m-d h:i:s");
                $invoice->invoice_parts[$i]->modified = date("Y-m-d h:i:s");
                $invoice->invoice_parts[$i]->price = $this->General->__sinchronizecurrency($invoice->invoice_parts[$i]->price);

                $invoice->invoice_parts[$i]->diskon = $this->General->__sinchronizecurrency($invoice->invoice_parts[$i]->diskon);
                $invoice->invoice_parts[$i]->total_harga = $this->General->__sinchronizecurrency($invoice->invoice_parts[$i]->total_harga);

                $invoice->invoice_parts[$i]->branch_code = $invoice->branch_code;
                $invoice->invoice_parts[$i]->branch_id = $invoice->branch_id;
            }else{
                unset($invoice->invoice_parts[$i]);
            }
          }
        }

        if($setStatus){
            if ($this->Invoices->save($invoice,[ 'associated' => ['InvoiceParts','InvoiceJasas']])) {
                $setStatus = 1;
                $message = 'The data has been saved.';

            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }
        }else{
            $setStatus = 0;
            if(isset($message)) $message=$message;
            else $message = 'Saldo stock tidak memenuhi.';
        }

        if($setStatus){
            $connection->commit();
            $message = 'The data has been saved.';
            $this->Flash->set(__($message));
            return $this->redirect(['action' => 'index']);
        }else {
            $this->Flash->set(__($message));
            $connection->rollback();
        }
    }

    $CorporateTable = $this->fetchTable('Masters.Corporates');
    $corporate = $CorporateTable
                ->find('list',
                    keyField : 'id',
                    valueField : 'name'
                )
                ->toArray();

    $Employees = $this->fetchTable('Masters.Employees');
    $mekanik = $Employees
                ->find('list',
                    keyField : 'employee_code',
                    valueField : 'nama_mekanik'
                )
                ->toArray();
                
     $Motors = $this->fetchTable('Masters.Motorcycles');            
     $tipemtr = $Motors
                ->find('list',
                keyField : 'type_mtr',
                valueField : 'type_mtr'
                )
                ->order(['type_mtr'=>'asc'])
                ->toArray(); 
                    
    $listpayment = ['Cash','QRIS','Transfer Bank','EDC/CARD','Piutang'];                  
    $this->set(compact('data','mekanik','invoice','corporate','listpayment'));
}

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $data = $this->Invoices->get($id);
        if ($this->Invoices->delete($data)) {
            $this->Flash->success(__('The user has been deleted.'));
        } else {
            $this->Flash->error(__('The user could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    function getCustomer($nopol){

        $customerstable = $this->fetchTable('Masters.Customers');
        $getCustomer = $customerstable->find()->where(['nopol'=>$nopol])
                        ->join([
                            [
                                'alias'=>'custcompany',
                                'table'=>'mst_perusahaan',
                                'type'=>'left',
                                'conditions'=>'corporate_id=custcompany.id'
                            ]
                        ])
                        ->select(['nama','alamat','type_customer','corporate_id','custcompany.discount_jasa','custcompany.discount_part'])
                        ->first();
        echo json_encode($getCustomer);
        exit;
    }
    function getSparepart($partnumber){
        $warehouseTable = $this->fetchTable('Masters.Warehouses');
        $getWarehouse = $warehouseTable->find()
            ->where(['branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])
        ->first();
        $parttable = $this->fetchTable('Transactions.StockParts');
        $getParts = $parttable->find()
                ->join([
                    [
                        'alias' => 'parts',
                        'table' => 'mst_parts',
                        'type' => 'INNER',
                        'conditions' => 'StockParts.partnumber = parts.partnumber'
                    ]
                ])
                ->where([
                    'StockParts.partnumber' => $partnumber,
                    'StockParts.branch_code' => $this->getRequest()->getSession()->read('Auth.branch_code'),
                    'StockParts.warehouse_code' => $getWarehouse->kode_gudang
                ])
                ->select(['StockParts.id',
                'StockParts.warehouse_id',
                'StockParts.warehouse_code',
                'StockParts.warehouse_name',
                'StockParts.branch_id',
                'StockParts.branch_code',
                'StockParts.rak_id',
                'StockParts.rak',
                'StockParts.partnumber',
                'StockParts.partdesc',
                'StockParts.qty',
                'parts.harga'])
                ->first();
        
        echo json_encode($getParts);
        exit;
    }
    function getService($kodeJasa){

        $tabel = $this->fetchTable('Masters.Jasas');
        $getData = $tabel->find()->where(['kode_jasa'=>$kodeJasa])
                        ->first();
        echo json_encode($getData);
        exit;
    }

    function getpartdetail(){
        $this->autoRender = false;
        $keyword = $this->request->getQuery('term');

        $parttable = $this->fetchTable('Transactions.StockParts');
        $suggestions = $parttable
            ->find('list',
            keyField : 'partnumber',
            valueField : 'partnumber'
            )->where(['partnumber LIKE' => '%' . $keyword . '%','branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])
            ->toArray();
        foreach($suggestions as $i=>$v){
            $result[$i] = ['id'=>$i,'label'=>$v,'value'=>$v];
        }
        echo json_encode($result);
        exit;
    }

   /* function batal($id){
        $this->request->allowMethod(['post', 'delete']);
        $connection = ConnectionManager::get('default');
        $connection->begin();
        $data = $this->Invoices->get($id,
            contain : ['InvoiceJasas','InvoiceParts']
        );
        if($data->status == 1){
            $this->Flash->success(__('Faktur Penjualan  '.$data->kode_workshop.' sudah dibatalkan sebelumnya.'));
            return $this->redirect(['action' => 'index']);
        }
        $data->status = 1;
        $update = $this->Invoices->save($data);
        if ($update) {
            //add log trans
            $logpartTable = $this->fetchTable('Transactions.LogParts');
            foreach($data->invoice_parts as $i=>$v){
                
                $entLog = $logpartTable->newEmptyEntity();

                $entLog->trx_code = $data->kode_workshop;
                $entLog->trx_date = $data->trans_date;
                $entLog->part_no = $v->partnumber;
                $entLog->part_name = $v->partdesc;
                $entLog->in_out = 'I';
                $entLog->qty = $v->qty;
                $entLog->warehouse_code = $v->warehouse_code;
                $entLog->warehouse_id = $v->warehouse_id;
                $entLog->rak_code = $v->rak_code;
                $entLog->rak_id = $v->rak_id;
                $entLog->branch_id = $v->branch_id;
                $entLog->branch_code = $v->branch_code;
                $resulLogs = $logpartTable->save($entLog);
                if(!$logpartTable->save($entLog)){
                   
                    $setStatus = 0;
                    $message = 'Fail add log partnumber. Please, try again.';
                }else{
                    
                      //update mst stok
                      $parttable = $this->fetchTable('Transactions.StockParts');
                      $getStocks = $parttable->find()->where(['partnumber'=>$v['partnumber'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                              //dd($v);
                      $getStocks->qty = $getStocks->qty + $v['qty']; 
                      if(!$parttable->save($getStocks)){
                            $setStatus = 0;
                            $message = 'Fail update stocks. Please, try again.';
                            break;
                      }else{
                            $setStatus = 1;
                            $message = 'The data has been saved.';
                      }
                }


            }
          
            $connection->commit();
            $this->Flash->success(__('Faktur Penjualan sudah dibatalkan.'));
        } else {
            $connection->rollback();
            $this->Flash->error(__('Faktur Penjualan  gagal dibatalkan. Silakan mencoba kembali.'));
        }

        return $this->redirect(['action' => 'index']);
    }
*/
   public function batal($id)
{
    $this->request->allowMethod(['post', 'delete']);
    $connection = ConnectionManager::get('default');
    $connection->begin();
    $data = $this->Invoices->get($id, [
        'contain' => ['InvoiceJasas', 'InvoiceParts']
    ]);

    if ($data->status == 1) {
        $this->Flash->success(__('Faktur Penjualan ' . $data->kode_workshop . ' sudah dibatalkan sebelumnya.'));
        return $this->redirect(['action' => 'index']);
    }

    $data->status = 1;
    $update = $this->Invoices->save($data);
    if ($update) {
        
        // Tambahkan log trans
    $logpartTable = $this->fetchTable('Transactions.LogParts');
    foreach ($data->invoice_parts as $v) {
    $entLog = $logpartTable->newEmptyEntity();

    // Tentukan trx_code berdasarkan kondisi
    if ($data->status == '1') {
        $entLog->trx_code = 'BATAL-' . $data->kode_workshop;
    } else {
        $entLog->trx_code = $data->kode_workshop;
    }

    $entLog->trx_date = $data->trans_date;
    $entLog->part_no = $v->partnumber;
    $entLog->part_name = $v->partdesc;
    $entLog->in_out = 'I';
    $entLog->qty = $v->qty;
    $entLog->warehouse_code = $v->warehouse_code;
    $entLog->warehouse_id = $v->warehouse_id;
    $entLog->rak_code = $v->rak_code;
    $entLog->rak_id = $v->rak_id;
    $entLog->branch_id = $v->branch_id;
    $entLog->branch_code = $v->branch_code;
            if (!$logpartTable->save($entLog)) {
                $connection->rollback();
                $this->Flash->error(__('Fail add log partnumber. Please, try again.'));
                return $this->redirect(['action' => 'index']);
            } else {
                // Update mst stok
                $parttable = $this->fetchTable('Transactions.StockParts');
                $getStocks = $parttable->find()->where([
                    'partnumber' => $v['partnumber'],
                    'rak' => $v['rak_code'],
                    'warehouse_code' => $v['warehouse_code']
                ])->first();

                $getStocks->qty = $getStocks->qty + $v['qty'];
                if (!$parttable->save($getStocks)) {
                    $connection->rollback();
                    $this->Flash->error(__('Fail update stocks. Please, try again.'));
                    return $this->redirect(['action' => 'index']);
                }
            }
        }

        // Perbarui kolom status pada tabel workshops_dtlparts dan workshops_dtlservices
        $this->fetchTable('Transactions.InvoiceParts')->updateAll(['status' => 1], ['workshop_id' => $data->id]);
        $this->fetchTable('Transactions.InvoiceJasas')->updateAll(['status' => 1], ['workshop_id' => $data->id]);

        $connection->commit();
        $this->Flash->success(__('Faktur Penjualan sudah dibatalkan.'));
    } else {
        $connection->rollback();
        $this->Flash->error(__('Faktur Penjualan gagal dibatalkan. Silakan mencoba kembali.'));
    }

    return $this->redirect(['action' => 'index']);
}


        /*// Hapus data terkait di tabel workshops_dtlparts dan workshops_dtlservices
        $this->fetchTable('workshops_dtlparts')->deleteAll(['workshop_id' => $data->id]);
        $this->fetchTable('workshops_dtlservices')->deleteAll(['workshop_id' => $data->id]);

        $connection->commit();
        $this->Flash->success(__('Faktur Penjualan sudah dibatalkan.'));
    } else {
        $connection->rollback();
        $this->Flash->error(__('Faktur Penjualan gagal dibatalkan. Silakan mencoba kembali.'));
    }

    return $this->redirect(['action' => 'index']);
}*/


    public function printpdf($id = null)
    {
        $listpayment = ['Cash','QRIS','Transfer Bank','EDC/CARD','Piutang'];            
        $CorporateTable = $this->fetchTable('Masters.Corporates');
        $corporates = $CorporateTable
                    ->find('list',
                        keyField : 'id',
                        valueField : 'name'
                    )
                    ->toArray();
        $corporate = $corporates   ;         
        $corporate +=['Other'=>'Other']; 




        $CompaniesTable = $this->fetchTable('SystemConfigurations.Companies');
        $companies = $CompaniesTable->find()->first();

        $Employees = $this->fetchTable('Masters.Employees');
        $mekanik = $Employees
                    ->find('list',
                        keyField : 'employee_code',
                        valueField : 'nama_mekanik'
                    )
                    ->toArray();


        $this->viewBuilder()->setLayout('print');
        $data['titlePage'] = 'Faktur Penjualan';
        $data['titleMenu'] = 'View Data Faktur Penjualan';
        $invoice = $this->Invoices->get($id, contain: ['InvoiceJasas','InvoiceParts']);
        $this->set(compact('data','invoice','companies','mekanik','corporate','listpayment'));

            // Render the view and extract the HTML content
        $response = $this->render('prints'); // Render the view
        $html = $response->getBody()->__toString(); // Convert body to string

    
            // Initialize mPDF
        // $mpdf = new Mpdf();
        $mpdf = new Mpdf([
            'format' => 'A4', // Set format ke A5
            'orientation' => 'P', // Portrait (atau 'L' untuk Landscape)
        ]);
        // $mpdf->SetFont('Arial', '', 18); // Coba ukuran yang lebih besar
        // Load HTML content
        $mpdf->WriteHTML($html);
        
        // Output the PDF (send to browser or save it as a file)
        $mpdf->Output("Invoice-{$invoice->id}.pdf", \Mpdf\Output\Destination::INLINE); // INLINE to view in browser

    }

}
