<?php
declare(strict_types=1);

namespace SystemConfigurations\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

class CompaniesTable extends Table
{
    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('companies');
        $this->setDisplayField('name');
        $this->setPrimaryKey('id');

        $this->addBehavior('Timestamp');

        $this->hasMany('Departements', [
            'foreignKey' => 'company_id',
            'className' => 'UserPriviledges.Departements',
        ]);
        $this->hasMany('UserProfiles', [
            'foreignKey' => 'company_id',
            'className' => 'UserPriviledges.UserProfiles',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->uuid('id')
            ->allowEmptyString('id', null, 'create');

        $validator
            ->scalar('company_code')
            ->maxLength('company_code', 10)
            ->requirePresence('company_code', 'create')
            ->notEmptyString('company_code');

        $validator
            ->scalar('name')
            ->maxLength('name', 100)
            ->requirePresence('name', 'create')
            ->notEmptyString('name');

        $validator
            ->scalar('address')
            ->maxLength('address', 200)
            ->requirePresence('address', 'create')
            ->notEmptyString('address');

        $validator
            ->scalar('phone_number')
            ->maxLength('phone_number', 20)
            ->requirePresence('phone_number', 'create')
            ->notEmptyString('phone_number');

        $validator
            ->scalar('fax_number')
            ->maxLength('fax_number', 20)
            ->requirePresence('fax_number', 'create')
            ->notEmptyString('fax_number');

        $validator
            ->scalar('npwp')
            ->maxLength('npwp', 30)
            ->requirePresence('npwp', 'create')
            ->notEmptyString('npwp');

        return $validator;
    }
}
