<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $this->Html->link('Home', ['plugin' => 'SystemConfigurations', 'controller' => 'home', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Report', ['plugin' => 'Reports', 'controller' => 'ReportPriceHistory', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Price History', ['plugin' => 'Reports', 'controller' => 'ReportPriceHistory', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item active">Index</li>
            </ol>
        </div>

        <?php if ($this->getRequest()->getSession()->read('Flash')) : ?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3"><?= $this->Flash->render() ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></button></div>
                </div>
            </div>
        <?php endif; ?>

        <div class="row">
            <div class="col-md-6">
                <?= $this->Form->create(null, ['type' => 'post']) ?>

                <div class="form-group">
                    <label for="filter_type">Filter Berdasarkan:</label>
                    <select name="filter_type" id="filter_type" class="form-control">
                        <option value="partnumber">Part Number</option>
                        <option value="date">Tanggal</option>
                        <option value="both">Keduanya</option>
                    </select>
                </div>

                <div class="form-group">
                    <label for="partnumber">Part Number:</label>
                    <input type="text" name="partnumber" id="partnumber" class="form-control" value="<?= isset($partnumber) ? $partnumber : '' ?>">
                </div>

                <div class="form-group">
                    <label for="start">Tanggal Mulai:</label>
                    <input type="date" name="start" id="start" class="form-control" value="<?= isset($start) ? $start : '' ?>" required>
                </div>

                <div class="form-group">
                    <label for="end">Tanggal Selesai:</label>
                    <input type="date" name="end" id="end" class="form-control" value="<?= isset($end) ? $end : '' ?>" required>
                </div>

                <button type="submit" class="btn btn-primary">Tampilkan</button>
                <?= $this->Form->end() ?>
            </div>
        </div>

        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script> 
        <script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
        <link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">

        <script>
            $(function() {
                $("#partnumber").autocomplete({
                    source: function(request, response) {
                        $.ajax({
                            url: "/report-price-history/autocompletePart", 
                            dataType: "json",
                            data: {
                                term: request.term
                            },
                            success: function(data) {
                                response(data);
                            }
                        });
                    },
                    minLength: 2,
                    select: function(event, ui) {
                        $("#partnumber").val(ui.item.value);
                    }
                });

                // Toggle date fields and required attribute based on filter type
                $("#filter_type").change(function() {
                    const selectedType = $(this).val();
                    if (selectedType === 'partnumber') {
                        $("#start, #end").prop("disabled", true).prop("required", false);
                    } else {
                        $("#start, #end").prop("disabled", false).prop("required", true);
                    }
                }).change(); // Trigger initial state on page load
            });
        </script>

        <?php if (isset($result) && !empty($result)) : ?>
            <table class="table table-bordered">
                <thead>
                    <tr>
                        <th>Part Number</th>
                        <th>Part Description</th>
                        <th>Harga Beli</th>
                        <th>Berlaku Dari</th>
                        <th>Berlaku Sampai</th>
                        <th>Sumber</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($result as $row) : ?>
                        <tr>
                            <td><?= $row['partnumber'] ?></td>
                            <td><?= $row['deskripsi'] ?></td> 
                            <td><?= $row['harga_beli'] ?></td>
                            <td><?= $row['valid_from'] ?></td>
                            <td><?= $row['valid_to'] ? $row['valid_to'] : '-' ?></td>
                            <td><?= $row['source'] ?></td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>

    </div>
</div>