<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $this->Html->link('Home', ['plugin' => 'SystemConfigurations', 'controller' => 'home', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Report', ['plugin' => 'Reports', 'controller' => 'ReportPenjualanPartHpps', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Penjualan Part HPP', ['plugin' => 'Reports', 'controller' => 'ReportPenjualanPartHpps', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item active">Index</li>
            </ol>
        </div>
        <?php if ($this->getRequest()->getSession()->read('Flash')) : ?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3"><?= $this->Flash->render() ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></button></div>
                </div>
            </div>
        <?php endif; ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row col-lg-12">
                            <div class="col-md-6 col-lg-6">
                                <h4 class="card-title"><?= $company['name'] ?></h4>
                                <p>Tanggal: <?= $periode ?></p>
                                <p><strong>Metode HPP yang Digunakan:</strong> Berdasarkan Harga Beli Terbaru (Tanggal Modifikasi atau Tanggal Pembelian Terakhir)</p>
                                <p><strong>Rumus HPP:</strong> Harga Pembelian Terakhir × Jumlah Barang</p>
                                <p><strong>Rumus Profit Part:</strong> Profit = Total Penjualan - Total HPP</p>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <table id="InvoiceDetails" class="table table-bordered table-striped">
                                <thead style="background-color: #f2f2f2;">
                                    <tr class="active">
                                        <th>Tanggal</th>
                                        <th>No Transaksi</th>
                                        <th>Nopol</th>
                                        <th>Mekanik</th>
                                        <th>No Part</th>
                                        <th>Nama Part</th>
                                        <th>Qty</th>
                                        <th>Harga</th>
                                        <th>Diskon</th>
                                        <th>Total Harga</th>
                                        <th>HPP Part</th>
                                        <th>Profit Part</th>
                                        <th>Tanggal HPP Efektif</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php
                                    $totalHarga = 0;
                                    $totalHPP = 0;
                                    $totalProfit = 0;
                                    foreach ($result as $v) {
                                        $totalHarga += $v['total_harga'];
                                        $totalHPP += $v['total_hpp'];
                                        $totalProfit += $v['profit'];
                                    ?>
                                        <tr>
                                            <td><?= h($v['trans_date']) ?></td>
                                            <td><?= h($v['kode_workshop']) ?></td>
                                            <td><?= h($v['nopol']) ?></td>
                                            <td><?= h($v['nama_mekanik']) ?></td>
                                            <td><?= h($v['partnumber']) ?></td>
                                            <td><?= h($v['partdesc']) ?></td>
                                            <td><?= $v['total_qty'] ?? 0 ?></td> <td class="text-end"><?= isset($v['price']) ? number_format($v['price']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['diskon']) ? number_format($v['diskon']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['total_harga']) ? number_format($v['total_harga']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['total_hpp']) ? number_format($v['total_hpp']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['profit']) ? number_format($v['profit']) : '' ?></td>
                                            <td class="text-end"><?= isset($v['hpp_effective_date']) ? h($v['hpp_effective_date']) : '' ?></td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                                <tfoot style="background-color: #f2f2f2;">
                                    <tr>
                                        <th colspan="10" class="text-end">Total</th>
                                        <th class="text-end"><?= number_format($totalHPP) ?></th>
                                        <th class="text-end"><?= number_format($totalProfit) ?></th>
                                        <th></th>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>
                        <div class="mt-4">
                            <p><strong>Total Profit Part:</strong> <?= number_format($totalProfitPart) ?></p>
                            <p><strong>Total Profit Jasa:</strong> <?= number_format($totalProfitJasa) ?></p>
                            <p><strong>Total Profit:</strong> <?= number_format($totalProfit + $totalProfitJasa) ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>