<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $this->Html->link('Home', ['plugin' => 'SystemConfigurations', 'controller' => 'home', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Report', ['plugin' => 'Reports', 'controller' => 'ReportNewCustomers', 'action' => 'index']) ?></li> 
                <li class="breadcrumb-item active">Laporan Pelanggan Baru</li> 
            </ol>
        </div>

        <?= $this->Flash->render() ?>

        <div class="row">
            <div class="col-xs-12">
                <div class="card">
                    <?= $this->Form->create(null, ['url' => ['plugin' => 'Reports', 'controller' => 'ReportNewCustomers', 'action' => 'index'], 'method' => 'post']) ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col">
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label">Tanggal Awal</label>
                                    <div class="col-sm-4">
                                        <?= $this->Form->control('startDate', [
                                            'class' => 'form-control datepicker',
                                            'placeholder' => 'yyyy-mm-dd',
                                            'label' => false,
                                            'type' => 'date',
                                            'readonly' => false,
                                            'autocomplete' => 'off',
                                            'value' => $startDate ?? null
                                        ]) ?>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label">Tanggal Akhir</label>
                                    <div class="col-sm-4">
                                        <?= $this->Form->control('endDate', [
                                            'class' => 'form-control datepicker',
                                            'placeholder' => 'yyyy-mm-dd',
                                            'label' => false,
                                            'type' => 'date',
                                            'readonly' => false,
                                            'autocomplete' => 'off',
                                            'value' => $endDate ?? null
                                        ]) ?>
                                    </div>
                                </div>
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label">Export</label>
                                    <div class="col-sm-9">
                                        <div class="form-group m-t-15 m-checkbox-inline mb-0 custom-radio-ml">
                                            <?= $this->Form->radio('type', ['html' => 'html', 'excel' => 'excel', 'pdf' => 'pdf'], ['required' => true, 'value' => 'html']) ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer text-end">
                        <div class="text-start mt-4 mb-3">
                            <?= $this->Form->button('Submit', ['class' => 'btn btn-primary', 'name' => 'btnSubmitForm']) ?>
                        </div>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function () {
        $('.datepicker').datepicker({
            autoclose: true,
            format: "yyyy-mm-dd",
            dateFormat: "yy-mm-dd" // Pastikan format ini sesuai dengan yang Anda harapkan di controller
        });
    });
</script>