<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPurchasesController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {

        $data['titlePage'] = 'Report Pembelian';
      $data['titleMenu'] = 'Report Pembelian';
      if ($this->request->is('post')) { 
          $dataTable = $this->fetchTable('Transactions.Purchases');
          $results = $dataTable->find()
                  ->where(function ($exp, $q) {
                      return $exp->between('purchase_date', $this->request->getData('start'), $this->request->getData('end'));
                    })
                  ->contain(['PurchaseDetails'])
                  ->order(['purchase_code'=>'asc'])
                  ->all();
            
            $dataReports=[];    
            $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
            $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
         
            $supllierTable = $this->fetchTable('Masters.Suppliers');
            $suppliers = $supllierTable
                    ->find('list', [
                        'keyField' => 'id',
                        'valueField' => 'name'
                    ])
                    ->order(['name'=>'asc'])
                    ->where(['status =' => 1])
                    ->toArray();    
            
            $k = 0;
            $grandTotal = 0;                
            foreach($results as $i => $v){
                foreach($v->purchase_details as $l => $j){
                    $dataReports[$k]['purchase_code'] = $v->purchase_code;
                    $dataReports[$k]['type_transaction'] = $v->type_transaction;
                    $dataReports[$k]['purchase_date'] = $v->purchase_date;
                    $dataReports[$k]['supplier_name'] = @$suppliers[$v->supplier_id];
                    $dataReports[$k]['supplier_code'] = $v->supplier_code;
                    $dataReports[$k]['purchase_ref'] = $v->purchase_ref;
                    $dataReports[$k]['partnumber'] = $j->partnumber;
                    $dataReports[$k]['partdesc'] = $j->partdesc;
                    $dataReports[$k]['price'] = $j->price;
                    $dataReports[$k]['qty'] = $j->qty;
                    $dataReports[$k]['total'] = $j->total;
                    $grandTotal += $j->total;
                    $k++;
                }   
            }

            if(empty($dataReports)){
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            switch ($this->request->getData('type')) {
                case 'html':
                    $file = 'html';
                    break;
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $periode = date("d F Y", strtotime($this->request->getData('start'))).' - '.date("d F Y", strtotime($this->request->getData('end')));
            $this->set(compact('data', 'periode', 'dataReports', 'company', 'grandTotal'));
            $this->render($file);
        }
        $this->set(compact('data'));
    }
}
