<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

class ReportProfitsController extends AppController
{
    public function index()
    {
        $data['titlePage'] = 'Report Profit';
        $data['titleMenu'] = 'Report Profit';
        if ($this->request->is('post')) {

            $conn = ConnectionManager::get('default');
            
            $start = $this->request->getData('start');
            $finish = $this->request->getData('end');

            $datas = $conn->execute("
                SELECT SUM(part) part, SUM(jasa) jasa FROM (
                    SELECT 
                        SUM(b.total_harga - b.diskon) part, 
                        0 jasa
                    FROM workshops a 
                    JOIN workshops_dtlparts b ON a.id = b.workshop_id
                    WHERE trans_date BETWEEN '$start' AND '$finish' AND a.status != '1' AND b.status != '1'
                    
                    UNION ALL

                    SELECT 
                        0, 
                        SUM(b.total_harga - b.diskon) jasa
                    FROM workshops a 
                    JOIN workshops_dtlservices b ON a.id = b.workshop_id
                    WHERE trans_date BETWEEN '$start' AND '$finish' AND a.status != '1' AND b.status != '1'
                ) a
            ");

            $partAndJasa = $datas->fetchAll('assoc');
            $totalPendapatan = $partAndJasa[0]['part'] + $partAndJasa[0]['jasa'];

            $diskonTotal = $conn->execute("
                SELECT SUM(disc) AS total_disc
                FROM workshops
                WHERE trans_date BETWEEN '$start' AND '$finish' AND status != '1'
            ")->fetch('assoc');

            $pendapatanNet = $totalPendapatan - $diskonTotal['total_disc'];

            $data['pendapatan'] = $partAndJasa;
            $data['total_pendapatan'] = $totalPendapatan;
            $data['total_diskon'] = $diskonTotal['total_disc'];
            $data['pendapatan_net'] = $pendapatanNet;

            $datasB = $conn->execute("
                SELECT SUM(b.total) total 
                FROM purchases a JOIN purchase_details b ON a.id = b.purchase_id 
                WHERE a.purchase_date BETWEEN '$start' AND '$finish'
            ");
            $data['pengeluaran'] = $datasB->fetchAll('assoc'); 
         
            // Pengeluaran Kas
            $datasKas = $conn->execute("
                SELECT SUM(amount) total 
                FROM petty_cash 
                WHERE trx_date BETWEEN '$start' AND '$finish' AND trx_type = 'K'
            ");
            $data['pengeluaran_kas'] = $datasKas->fetchAll('assoc'); 
         
            $datasKasOther = $conn->execute("
                SELECT SUM(amount) total 
                FROM petty_cash 
                WHERE trx_date BETWEEN '$start' AND '$finish' AND trx_type = 'O'
            ");
            $data['pengeluaran_kas_other'] = $datasKasOther->fetchAll('assoc'); 

            $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
            $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
     
            switch ($this->request->getData('type')) {
                case 'html':
                    $file = 'html';
                    break;
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $periode = date("d F Y", strtotime($this->request->getData('start'))).' - '.date("d F Y", strtotime($this->request->getData('end')));
            $this->set(compact('data', 'periode', 'company'));
            $this->render($file);
        }
        $this->set(compact('data'));
    }
}
