<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPenjualanPartsController extends AppController
{
    public $PhpExcel = null;

    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Penjualan Part';
        $data['titleMenu'] = 'Report Penjualan Part';

        if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');

            // Validasi input tanggal
            if (!$start || !$end || !strtotime($start) || !strtotime($end)) {
                $this->Flash->error(__('Tanggal tidak valid.'));
                return $this->redirect(['action' => 'index']);
            }

            try {
                $result = $conn->execute("SELECT a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, c.price * sub.total_qty as total_sales, c.total_harga, c.price, c.diskon
                                          FROM workshops a 
                                          LEFT JOIN (
                                              SELECT workshop_id, partnumber, SUM(qty) as total_qty
                                              FROM workshops_dtlparts
                                              GROUP BY workshop_id, partnumber
                                          ) sub ON a.id = sub.workshop_id
                                          LEFT JOIN workshops_dtlparts c ON a.id = c.workshop_id AND sub.partnumber = c.partnumber
                                          LEFT JOIN purchase_details pd ON c.partnumber = pd.partnumber
                                          LEFT JOIN mst_employes e ON a.mekanik = e.employee_code
                                          WHERE a.trans_date >= :start AND a.trans_date <= :end 
                                            AND a.status != '1' 
                                            AND c.status != '1'
                                          GROUP BY a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, c.partnumber, c.partdesc, sub.total_qty, c.total_harga, c.price, c.diskon
                                          ORDER BY a.trans_date ASC", ['start' => $start, 'end' => $end])->fetchAll('assoc');
            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ' . $e->getMessage()));
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            // Hitung HPP menggunakan metode LIFO
            foreach ($result as &$data) {
                // Ambil data persediaan untuk partnumber yang sesuai
                $inventory = $conn->execute("SELECT pd.price, pd.qty
                                             FROM purchase_details pd
                                             WHERE pd.partnumber = :partnumber
                                             ORDER BY pd.created DESC", ['partnumber' => $data['partnumber']])->fetchAll('assoc');

                if (empty($inventory)) {
                    // Jika tidak ada data pembelian terkait, ambil harga beli dari tabel mst_parts
                    $part = $conn->execute("SELECT harga_beli
                                            FROM mst_parts
                                            WHERE partnumber = :partnumber", ['partnumber' => $data['partnumber']])->fetch('assoc');

                    if ($part) {
                        $data['total_hpp'] = $data['total_qty'] * $part['harga_beli'];
                    } else {
                        $data['total_hpp'] = null;
                    }
                } else {
                    $unitsSold = $data['total_qty'];
                    $totalHpp = 0;

                    foreach ($inventory as $item) {
                        if ($unitsSold <= 0) {
                            break;
                        }

                        $unitsToUse = min($unitsSold, $item['qty']);
                        $totalHpp += $unitsToUse * $item['price'];
                        $unitsSold -= $unitsToUse;
                    }

                    $data['total_hpp'] = $totalHpp;
                }

                // Rumus Profit: Total Penjualan - Total HPP
                $data['profit'] = $data['total_sales'] - $data['total_hpp'];
            }

            $company = [
                'name' => 'AHASS RAJAWALI PUTERA',
                'address' => 'Alamat Perusahaan'
            ];

            switch ($this->request->getData('type')) {
                case 'html':
                    $file = 'html';
                    break;
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            $this->set(compact('data', 'periode', 'company', 'result'));
            $this->render($file);
        }

        $this->set(compact('data'));
    }
}