<?php
use Cake\Routing\RouteBuilder;
use Cake\Routing\Router;

Router::plugin(
    'Reports',
    ['path' => '/reports'], // Path untuk mengakses plugin Anda
    function (RouteBuilder $routes) {
        $routes->connect(
            '/', // Untuk mengakses action index dari ReportsController (daftar laporan)
            ['controller' => 'Reports', 'action' => 'index']
        );
        $routes->connect(
            '/new-customers', // Untuk mengakses ReportNewCustomersController
            ['controller' => 'ReportNewCustomers', 'action' => 'index']
        );
        $routes->connect(
            '/new-customers/excel', // Untuk export Excel
            ['controller' => 'ReportNewCustomers', 'action' => 'index', 'type' => 'excel']
        );
        $routes->connect(
            '/new-customers/pdf', // Untuk export PDF
            ['controller' => 'ReportNewCustomers', 'action' => 'index', 'type' => 'pdf']
        );
        $routes->fallbacks(); // Penting untuk menangani route yang tidak terdefinisi
    }
);