<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $this->Html->link('Home', ['plugin' => 'SystemConfigurations', 'controller' => 'home', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Master', ['plugin' => 'Masters', 'controller' => 'Parts', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Parts', ['plugin' => 'Masters', 'controller' => 'Parts', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item active">Index</li>
            </ol>
        </div>
        <!-- row -->
        <?php if ($this->getRequest()->getSession()->read('Flash')) { ?>
            <div class="row">
                <div class="col-md-12 col-lg-12">
                    <div class="alert alert-danger alert-dismissible fade show mb-3"><?= $this->Flash->render() ?> <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="btn-close"></div>
                </div>
            </div>
        <?php } ?>
        <div class="row">
            <div class="col-lg-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row col-lg-12">
                            <div class="col-md-6 col-lg-6">
                                <h4 class="card-title"><?= $data['titleMenu'] ?></h4>
                            </div>
                            <div class="col-md-6 col-lg-6 text-start text-lg-end">
                                <?= $this->Html->link('<i class="fa fa-plus" aria-hidden="true"></i> Add', ['action' => 'add'], ['class' => 'btn btn-sm btn-danger', 'escape' => false]) ?>
                                <?= $this->Html->link('<i class="fa fa-upload" aria-hidden="true"></i> Upload', ['action' => 'upload'], ['class' => 'btn btn-sm btn-success', 'escape' => false]) ?>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                            <?= $this->Form->create(null, ['type' => 'get']) ?>
                            <div class="row p-3 rounded mb-4" style="background-color: #f5f5f5;">
                                <div class="col-md-2"><h5 class="text-black align-text-middle">Search</h5></div>
                                <div class="col-md-4">
                                    <?= $this->Form->control('search', ['label' => false, 'class' => 'form-control', 'value' => $this->request->getQuery('search')]) ?>
                                </div>
                                <div class="col-md-2"><button class="btn btn-primary btn-sl-sm me-2" type="submit"><span class="me-2"><i class="fa fa-search"></i></span>Filter</button></div>
                            </div>
                            <?= $this->Form->end() ?>
                            <table class="table table-responsive-md table-sm mb-0 table-striped" id="examples">
                                <thead>
                                    <tr>
                                        <th>No Part</th>
                                        <th>Nama Part</th>
                                        <th>Kel Barang</th>
                                        <th>Harga Jual</th>
                                        <th>Harga Beli</th>
                                        <th>minstock</th>
                                        <th>maxstock</th>
                                        <th>status</th>
                                        <th></th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($parts as $i => $v) { ?>
                                        <tr>
                                            <td><?= $v->partnumber ?></td>
                                            <!-- Deskripsi/Nama Part Editable -->
                                            <td>
                                                <span class="editable-display"><?= $v->deskripsi ?></span>
                                                <input type="text" class="editable-input form-control form-control-sm d-none" 
                                                       data-id="<?= $v->id ?>" data-field="deskripsi" 
                                                       value="<?= $v->deskripsi ?>" />
                                                <i class="fa fa-edit edit-trigger ms-1" style="cursor: pointer;"></i>
                                                <i class="fa fa-check save-trigger ms-1 d-none" style="cursor: pointer;"></i>
                                                <i class="fa fa-times cancel-trigger ms-1 d-none" style="cursor: pointer;"></i>
                                            </td>
                                            <td><?= $v->kel_barang ?></td>
                                            <!-- Harga Jual Editable -->
                                            <td>
                                                <span class="editable-display"><?= $v->harga ?></span>
                                                <input type="number" class="editable-input form-control form-control-sm d-none" 
                                                       data-id="<?= $v->id ?>" data-field="harga" 
                                                       value="<?= $v->harga ?>" />
                                                <i class="fa fa-edit edit-trigger ms-1" style="cursor: pointer;"></i>
                                                <i class="fa fa-check save-trigger ms-1 d-none" style="cursor: pointer;"></i>
                                                <i class="fa fa-times cancel-trigger ms-1 d-none" style="cursor: pointer;"></i>
                                            </td>
                                            <!-- Harga Beli Editable -->
                                            <td>
                                                <span class="editable-display"><?= $v->harga_beli ?></span>
                                                <input type="number" class="editable-input form-control form-control-sm d-none" 
                                                       data-id="<?= $v->id ?>" data-field="harga_beli" 
                                                       value="<?= $v->harga_beli ?>" />
                                                <i class="fa fa-edit edit-trigger ms-1" style="cursor: pointer;"></i>
                                                <i class="fa fa-check save-trigger ms-1 d-none" style="cursor: pointer;"></i>
                                                <i class="fa fa-times cancel-trigger ms-1 d-none" style="cursor: pointer;"></i>
                                            </td>
                                            <td><?= $v->minstock ?></td>
                                            <td><?= $v->maxstock ?></td>
                                            <td><span class="badge badge-danger"><?= ($v->status == 'A') ? 'Active' : 'Not Active' ?></span></td>
                                            <td class="text-end">
                                                <?= $this->Html->link('<i class="fa fa-edit" aria-hidden="true"></i> Edit', ['action' => 'edit', $v->id], ['class' => 'btn btn-sm btn-primary', 'escape' => false]) ?>
                                                <?= $this->Form->postLink(
                                                    '<i class="fa fa-times" aria-hidden="true"></i> Delete',
                                                    ['action' => 'delete', $v->id],
                                                    ['confirm' => 'Apakah yakin ingin menghapus part ini?', 'class' => 'btn btn-sm btn-danger', 'escape' => false]
                                                ) ?>
                                            </td>
                                        </tr>
                                    <?php } ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-footer border-top-0">
                        <div class="row justify-content-end">
                            <div class="col-lg-12">
                                <div class="paginator">
                                    <ul class="pagination">
                                        <?= $this->Paginator->first('<< ' . __('first')) ?>
                                        <?= $this->Paginator->prev('< ' . __('previous')) ?>
                                        <?= $this->Paginator->numbers() ?>
                                        <?= $this->Paginator->next(__('next') . ' >') ?>
                                        <?= $this->Paginator->last(__('last') . ' >>') ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Add this script section at the bottom of your template -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const csrfToken = document.querySelector('meta[name="csrfToken"]').content;

    // Edit Trigger
    document.querySelectorAll('.edit-trigger').forEach(editBtn => {
        editBtn.addEventListener('click', function() {
            const td = this.closest('td');
            toggleEditElements(td, true);
        });
    });

    // Cancel Trigger
    document.querySelectorAll('.cancel-trigger').forEach(cancelBtn => {
        cancelBtn.addEventListener('click', function() {
            const td = this.closest('td');
            const input = td.querySelector('.editable-input');
            input.value = td.querySelector('.editable-display').textContent;
            toggleEditElements(td, false);
        });
    });

    // Save Trigger
    document.querySelectorAll('.save-trigger').forEach(saveBtn => {
        saveBtn.addEventListener('click', function() {
            const td = this.closest('td');
            const input = td.querySelector('.editable-input');
            const id = input.dataset.id;
            const field = input.dataset.field;
            const value = input.value;

            // Validasi untuk field deskripsi agar tidak kosong
            if (field === 'deskripsi' && value.trim() === '') {
                alert('Deskripsi tidak boleh kosong');
                return;
            }

            fetch('/masters/parts/inline-edit', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest'
                },
                body: JSON.stringify({ 
                    id: id,
                    field: field,
                    value: value,
                    _csrfToken: csrfToken
                })
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    td.querySelector('.editable-display').textContent = value;
                    toggleEditElements(td, false);
                } else {
                    alert('Error: ' + (data.message || 'Failed to update'));
                }
            })
            .catch(error => {
                console.error('Error:', error);
                alert('Network error occurred');
            });
        });
    });

    // Handle Enter key in input
    document.querySelectorAll('.editable-input').forEach(input => {
        input.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                this.closest('td').querySelector('.save-trigger').click();
            }
        });
    });

    function toggleEditElements(td, isEditing) {
        td.querySelector('.editable-display').classList.toggle('d-none', isEditing);
        td.querySelector('.edit-trigger').classList.toggle('d-none', isEditing);
        td.querySelector('.editable-input').classList.toggle('d-none', !isEditing);
        td.querySelector('.save-trigger').classList.toggle('d-none', !isEditing);
        td.querySelector('.cancel-trigger').classList.toggle('d-none', !isEditing);
        
        if (isEditing) {
            td.querySelector('.editable-input').focus();
        }
    }
});
</script>