<?php
namespace Masters\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;
use Cake\ORM\Rule\IsUnique;
class MotorcyclesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('mst_motor');

        $this->addBehavior('Timestamp');





    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {

        $validator
            ->scalar('motor_code')
            ->maxLength('motor_code', 15)
            ->requirePresence('motor_code', 'create')
            ->allowEmptyString('motor_code', 'Kode motor harus diisi', false)

            ;

        $validator
            ->scalar('type_mtr')
            ->maxLength('type_mtr', 45)
            ->requirePresence('type_mtr', 'create')
            ->allowEmptyString('type_mtr', 'Tipe Motor harus diisi', false)

            ;



        return $validator;
    }


}
