<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

class StocksController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Monitoring STOCK';
        $data['titleMenu'] = 'STOCK';

        $query = $this->Stocks->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'partnumber LIKE' => '%' . $search . '%',
                    'partdesc LIKE' => '%' . $search . '%',
                ]
            ]);
        }

        if ($this->request->getQuery('sort') && $this->request->getQuery('direction')) {
            $query = $query->order('Stocks.' . $this->request->getQuery('sort') . ' ' . $this->request->getQuery('direction'));
        } else {
            $query = $query->order('Stocks.created desc');
        }

        $stocks = $this->paginate($query);

        $this->set(compact('stocks', 'data'));
        $this->set('_serialize', ['stocks']);
    }

    public function download()
    {
        $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
        $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
        $trx_date = date("Y-m-d");
        $dataParts = $this->fetchTable('Masters.Parts')->find('list', [
            'keyField' => 'partnumber',
            'valueField' => 'harga'
        ])->toArray();
        $data = $this->fetchTable('Transactions.StockParts')->find()->order(['partnumber'])->all();
        $periode = date("d F Y", strtotime($trx_date));
        $this->set(compact('data', 'periode', 'dataParts', 'company'));
        $this->render('excel');
    }
}
?>