<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

class MotorcyclesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Motor';
        $data['titleMenu'] = 'Data Motor';
        
        $query = $this->Motorcycles->find('all');
        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'motor_code LIKE' => '%' . $search . '%',
                    'type_mtr LIKE' => '%' . $search . '%'
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Motorcycles.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Motorcycles.created desc');
        
        $motorcycles = $this->paginate($query);


      $this->set(compact('motorcycles','data'));
      $this->set('_serialize', ['motorcycles']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $motorcycle = $this->Motorcycles->get($id);

        $this->set('motorcycle', $motorcycle);
        $this->set('_serialize', ['motorcycle']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Motor';
        $data['titleMenu'] = 'Data Motor';
        //$this->loadComponent('General');
        //$setStatus = Y;
        $motorcycle = $this->Motorcycles->newEmptyEntity();
        if ($this->request->is('post')) {

            $connection = ConnectionManager::get('default');
            $connection->begin();
            $motorcycle = $this->Motorcycles->patchEntity($motorcycle, $this->request->getData());
            $motorcycle->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $motorcycle->modi_by = $this->getRequest()->getSession()->read('Auth.id');

            if ($this->Motorcycles->save($motorcycle)) {
                $setStatus = 1;
                $message = 'The data has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }


        $this->set(compact('motorcycle','data'));
        $this->set('_serialize', ['motorcycle']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Motor';
        $data['titleMenu'] = 'Data Motor';
		//$this->loadComponent('General');
        $motorcycle = $this->Motorcycles->get($id);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $motorcycle = $this->Motorcycles->patchEntity($motorcycle, $this->request->getData());
            $motorcycle->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $motorcycle->modi_by = $this->getRequest()->getSession()->read('Auth.id');


            if ($this->Motorcycles->save($motorcycle)) {
                $setStatus = 1;
                $message = 'The data has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }

        $this->set(compact('motorcycle','data'));
        $this->set('_serialize', ['motorcycle']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function delete($id = null)
     {
         $this->request->allowMethod(['post', 'delete']);
         $connection = ConnectionManager::get('default');
         $connection->begin();
         if(isset($this->request->data['id'])){
             $ids = explode(',',$this->request->data['id']);
         }else $ids = $id;

         foreach($ids as $i=>$v){
           $motorcycle = $this->Motorcycles->get($v);
           if ($this->Motorcycles->delete($motorcycle,[
             'dependent' => true,
             'cascadeCallbacks' => true
             ])) {
               $setStatus=1;
               $message = 'The data has been deleted.';
           } else {
               $setStatus=0;
               $message = 'The data with id: '.$v.' could not be deleted. Please, try again.';
               break;
           }
         }

         $this->Flash->error(__($message));
         if($setStatus){
             $connection->commit();
         }else {
             $connection->rollback();
         }
         return $this->redirect(['action' => 'index']);
     }



}
