// purchases.js - Script untuk form pembelian dengan Autocomplete

// --- Utility Functions (dari kode asli Anda) ---
function deleteRow(id){
    $('#'+$('#'+id).attr('rel')).detach();
}

function calculate_price_part(id){
    // Fungsi ini tampaknya tidak digunakan, tapi tetap disertakan
    var row = $("#"+id).attr('row');
    var qty = $("#purchase-details-"+row+"-qty").val();
    var price = getNum($("#purchase-details-"+row+"-price").val());
    var diskon_part = $("#purchase-details-"+row+"-disc-prosen").val();

    var prices = (qty*price);
    var diskon = prices * diskon_part/100;
    var total_harga = prices - diskon;
    
    $("#purchase-details-"+row+"-total").val(numberWithCommas(total_harga));
}

// Fungsi untuk menghitung total setelah diskon
function getDisc(id) {
    var row = $("#" + id).attr("row");
    
    // Ambil nilai dari setiap kolom di baris yang sama
    var qty = parseFloat($("#purchase-details-" + row + "-qty").val().replace(/,/g, '')) || 0;
    var price = parseFloat($("#purchase-details-" + row + "-price").val().replace(/,/g, '')) || 0;
    var discProsen = parseFloat($("#" + id).val().replace(/,/g, '')) || 0;
    
    // Pastikan nilai diskon tidak melebihi 100%
    if (discProsen > 100) {
        alert("Diskon tidak boleh lebih dari 100%");
        $("#" + id).val(100);
        discProsen = 100;
    }

    // Hitung total dengan diskon
    var subTotal = qty * price;
    var discAmount = subTotal * (discProsen / 100);
    var totalAfterDisc = subTotal - discAmount;
    
    // Perbarui nilai total di kolom yang sesuai
    $("#purchase-details-" + row + "-total").val(totalAfterDisc.toFixed(2));
    
    // Panggil fungsi untuk memperbarui grand total di footer
    sumTotal();
}

// Fungsi untuk menghitung total keseluruhan (subtotal, diskon, dan grand total)
function sumTotal() {
    var totalPurchase = 0;
    $("input[rel^='PurchaseDetailsTotal']").each(function() {
        totalPurchase += parseFloat($(this).val().replace(/,/g, '')) || 0;
    });

    var diskonGlobal = parseFloat($("#diskon").val().replace(/,/g, '')) || 0;
    
    var grandTotal = totalPurchase - diskonGlobal;

    $("#total").val(totalPurchase.toFixed(2));
    $("#grand-total").val(grandTotal.toFixed(2));
}

// Fungsi untuk menghitung total saat Qty atau Harga berubah
function getTotal(id) {
    var row = $("#" + id).attr("row");
    var qty = parseFloat($("#purchase-details-" + row + "-qty").val().replace(/,/g, '')) || 0;
    var price = parseFloat($("#purchase-details-" + row + "-price").val().replace(/,/g, '')) || 0;
    var subTotal = qty * price;
    
    // Dapatkan nilai diskon dari kolom yang sama
    var discProsen = parseFloat($("#purchase-details-" + row + "-disc-prosen").val().replace(/,/g, '')) || 0;
    
    // Hitung ulang total dengan diskon yang sudah ada
    var discAmount = subTotal * (discProsen / 100);
    var totalAfterDisc = subTotal - discAmount;

    $("#purchase-details-" + row + "-total").val(totalAfterDisc.toFixed(2));
    
    // Perbarui grand total
    sumTotal();
}

// --- Fungsi Autocomplete ---
/**
 * Inisialisasi jQuery UI Autocomplete untuk input partnumber.
 * @param {string|jQuery} elementSelector - Selector CSS atau objek jQuery untuk input(s).
 */
// purchases.js
// ... kode lainnya di atas

// Fungsi untuk menginisialisasi autocomplete pada elemen tertentu
function initSelectPart(element) {
    if (!$(element).data("autocomplete")) {
        $(element).autocomplete({
            delay: 500,
            minLength: 3,
            source: "/transactions/purchases/getpartdetail",
            select: function(event, ui) {
                // Tambahkan pemeriksaan di sini untuk ui.item
                if (ui.item) {
                    var row = $(this).attr("row");
                    if (row !== undefined) {
                        var fullText = ui.item.label;
                        var partnumber = ui.item.value;
                        
                        // Periksa apakah fullText terdefinisi sebelum menggunakan indexOf
                        if (fullText) {
                            var separatorIndex = fullText.indexOf(" - ");
                            if (separatorIndex !== -1) {
                                var desc = fullText.substring(separatorIndex + 3);
                                $("#purchase-details-" + row + "-partdesc").val(desc);
                                $(this).val(partnumber);
                                return false;
                            } else {
                                $("#purchase-details-" + row + "-partdesc").val('');
                            }
                        }
                    }
                }
            }
        });
    }
}


// Tambahkan event handler untuk otomatis uppercase, menghilangkan spasi, dan hanya mengizinkan huruf/angka
$(document).on('input', '.selectpart', function() {
    // Gunakan regex untuk menghapus semua karakter non-alfanumerik
    // dan pastikan input menjadi huruf besar
    this.value = this.value.toUpperCase().replace(/[^A-Z0-9]/g, '');
});

// --- Fungsi Dinamis Row (diperbaiki) ---
/**
 * Menambahkan baris baru ke tabel detail pembelian.
 * @param {string} base - URL dasar untuk getSparepart (tidak digunakan lagi untuk autocomplete, tapi disimpan untuk kompatibilitas).
 */
function addRowpart(base) { // base tidak digunakan oleh autocomplete, tapi mungkin oleh fungsi lain
    // Increment the counter
    var nextCounter = Number($('#tr_d_counter_purchase_details').val()) + 1;
    
    // Create a new row element
    var newRow = $('<tr>', { 
        id: 'tr_purchase_details_' + nextCounter, 
        class: 'active', 
        row: nextCounter 
    });

    // Construct the HTML content for the new row
    // --- PERUBAHAN PENTING: HAPUS onchange="searchpart(...)" ---
    var html = '';
    // Input partnumber tanpa onchange
    html += '<td width="250"><div class="input text"><input type="text" name="purchase_details[' + nextCounter + '][partnumber]" class="selectpart form-control" row="' + nextCounter + '" id="purchase-details-' + nextCounter + '-partnumber"></div></td>';
    html += '<td><div class="input text"><input type="text" name="purchase_details[' + nextCounter + '][partdesc]" class="form-control" row="' + nextCounter + '" id="purchase-details-' + nextCounter + '-partdesc"></div></td>';
    html += '<td width="100"><div class="input text"><input type="text" name="purchase_details[' + nextCounter + '][qty]" class="form-control currency" row="' + nextCounter + '" id="purchase-details-' + nextCounter + '-qty" onchange="getTotal(this.id)"></div></td>';
    html += '<td><div class="input text"><input type="text" name="purchase_details[' + nextCounter + '][price]" class="form-control" row="' + nextCounter + '" id="purchase-details-' + nextCounter + '-price" onchange="getTotal(this.id)"></div></td>';
    html += '<td><div class="input text"><input type="text" name="purchase_details[' + nextCounter + '][disc_prosen]" class="form-control" row="' + nextCounter + '" id="purchase-details-' + nextCounter + '-disc-prosen" onchange="getDisc(this.id)"></div></td>';
    html += '<td><div class="input text"><input type="text" name="purchase_details[' + nextCounter + '][total]" class="form-control currency ttotal" row="' + nextCounter + '" id="purchase-details-' + nextCounter + '-total" readonly rel="PurchaseDetailsTotal' + nextCounter + '"></div></td>';
    html += '<td><input type="button" id="delrowpurchase_details' + nextCounter + '" class="btn btn-danger btn-sm" value="-" rel="tr_purchase_details_' + nextCounter + '" onclick="deleteRow(this.id)"></td>';

    // Append the constructed HTML to `newRow`
    newRow.html(html);

    // Insert the new row before the hidden row
    $('#trhidden_d_counter_purchase_details').before(newRow);

    // Update the counter
    $('#tr_d_counter_purchase_details').val(nextCounter);

    // --- PERUBAHAN PENTING: Inisialisasi autocomplete untuk input baru ---
    // Inisialisasi autocomplete khusus untuk input yang baru ditambahkan
    initSelectPart('#purchase-details-' + nextCounter + '-partnumber');
    
    // Fokuskan ke input partnumber yang baru
    $('#purchase-details-' + nextCounter + '-partnumber').focus();
}

// --- Fungsi searchpart (diperbaiki atau dikomentari) ---
// Karena kita menggunakan autocomplete, fungsi ini bisa dihapus jika tidak digunakan
// oleh bagian lain dari aplikasi. Namun, jika masih dipakai, pastikan logikanya benar.
// Untuk sementara, kita perbaiki agar tidak menyebabkan error jika tetap dipanggil.
function searchpart(id, url){
    console.warn("Fungsi searchpart dipanggil, seharusnya digantikan oleh Autocomplete. ID:", id);
    // Logika lama - bisa menyebabkan duplikasi atau konflik
    // Disarankan untuk menghapus pemanggilan onchange=searchpart dari HTML jika memungkinkan
    /*
    var val = $("#"+id).val();
    var row = $("#"+id).attr('row');
    $.getJSON(url+'/'+val,function(data){
        if(data){
            var getDuplicateId = checkDuplicate3();
           if(getDuplicateId){
                var getRow = $("#"+getDuplicateId).attr('row');
                var getQty = Number($("#purchase-details-"+getRow+"-qty").val())+1;
                $("#purchase-details-"+getRow+"-qty").val(getQty);
               
                 $("#purchase-details-"+row+"-partnumber").val('');  
                $("#purchase-details-"+row+"-partnumber").focus();  
            }else{
                $("#purchase-details-"+row+"-partnumber").val(val);
                $("#purchase-details-"+row+"-partdesc").val(data.deskripsi); // Pastikan field ini ada di data
                $("#purchase-details-"+row+"-qty").val(1);

            }
        }
        getTotal(id); // Ini akan dipanggil lagi, mungkin menyebabkan perhitungan ganda
    });
    */
}

// Fungsi checkDuplicate3 (jika masih digunakan)
function checkDuplicate3() {
    var inputs = document.querySelectorAll('.selectpart');
    var values = Array.from(inputs).map(input => input.value.trim());
    var duplicateIds = [];
    var existingIds = [];

    inputs.forEach(input => {
        existingIds.push(input.id);
    });

    values.forEach((value, index) => {
        if (values.indexOf(value) !== index && !duplicateIds.includes(existingIds[index])) {
            duplicateIds.push(existingIds[values.indexOf(value)]);
            // console.log(index);
            // console.log(values.indexOf(value));
        }
    });

    return  duplicateIds.join(', ');
}

// --- Inisialisasi saat dokumen siap ---
$(document).ready(function() {
    // Inisialisasi autocomplete untuk elemen yang sudah ada saat halaman dimuat (baris pertama)
    initSelectPart('.selectpart');

    // Fokus ke input pertama
    if ($("#purchase-details-0-partnumber").length) {
        $("#purchase-details-0-partnumber").focus();
    }
});