<?php
/**
 * @var \App\View\AppView $this
 * @var \Cake\Datasource\EntityInterface $company
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Company'), ['action' => 'edit', $company->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Company'), ['action' => 'delete', $company->id], ['confirm' => __('Are you sure you want to delete # {0}?', $company->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Companies'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Company'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="companies view content">
            <h3><?= h($company->name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= h($company->id) ?></td>
                </tr>
                <tr>
                    <th><?= __('Company Code') ?></th>
                    <td><?= h($company->company_code) ?></td>
                </tr>
                <tr>
                    <th><?= __('Name') ?></th>
                    <td><?= h($company->name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Address') ?></th>
                    <td><?= h($company->address) ?></td>
                </tr>
                <tr>
                    <th><?= __('Npwp') ?></th>
                    <td><?= h($company->npwp) ?></td>
                </tr>
                <tr>
                    <th><?= __('Pkp') ?></th>
                    <td><?= h($company->pkp) ?></td>
                </tr>
                <tr>
                    <th><?= __('Seri Pajak') ?></th>
                    <td><?= h($company->seri_pajak) ?></td>
                </tr>
                <tr>
                    <th><?= __('Phone Num') ?></th>
                    <td><?= h($company->phone_num) ?></td>
                </tr>
                <tr>
                    <th><?= __('Fax Num') ?></th>
                    <td><?= h($company->fax_num) ?></td>
                </tr>
                <tr>
                    <th><?= __('Acc Mtd') ?></th>
                    <td><?= h($company->acc_mtd) ?></td>
                </tr>
                <tr>
                    <th><?= __('Acc Ytd') ?></th>
                    <td><?= h($company->acc_ytd) ?></td>
                </tr>
                <tr>
                    <th><?= __('Acc Lastyear') ?></th>
                    <td><?= h($company->acc_lastyear) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>
