<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\Cake\Datasource\EntityInterface> $companies
 */
?>
<div class="companies index content">
    <?= $this->Html->link(__('New Company'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Companies') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('company_code') ?></th>
                    <th><?= $this->Paginator->sort('name') ?></th>
                    <th><?= $this->Paginator->sort('address') ?></th>
                    <th><?= $this->Paginator->sort('npwp') ?></th>
                    <th><?= $this->Paginator->sort('pkp') ?></th>
                    <th><?= $this->Paginator->sort('seri_pajak') ?></th>
                    <th><?= $this->Paginator->sort('phone_num') ?></th>
                    <th><?= $this->Paginator->sort('fax_num') ?></th>
                    <th><?= $this->Paginator->sort('acc_mtd') ?></th>
                    <th><?= $this->Paginator->sort('acc_ytd') ?></th>
                    <th><?= $this->Paginator->sort('acc_lastyear') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($companies as $company): ?>
                <tr>
                    <td><?= h($company->id) ?></td>
                    <td><?= h($company->company_code) ?></td>
                    <td><?= h($company->name) ?></td>
                    <td><?= h($company->address) ?></td>
                    <td><?= h($company->npwp) ?></td>
                    <td><?= h($company->pkp) ?></td>
                    <td><?= h($company->seri_pajak) ?></td>
                    <td><?= h($company->phone_num) ?></td>
                    <td><?= h($company->fax_num) ?></td>
                    <td><?= h($company->acc_mtd) ?></td>
                    <td><?= h($company->acc_ytd) ?></td>
                    <td><?= h($company->acc_lastyear) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $company->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $company->id]) ?>
                        <?= $this->Form->postLink(__('Delete'), ['action' => 'delete', $company->id], ['confirm' => __('Are you sure you want to delete # {0}?', $company->id)]) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>
