<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * MstRunNums Model
 *
 * @property \App\Model\Table\ValsTable|\Cake\ORM\Association\BelongsTo $Vals
 *
 * @method \App\Model\Entity\MstRunNum get($primaryKey, $options = [])
 * @method \App\Model\Entity\MstRunNum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\MstRunNum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\MstRunNum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\MstRunNum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\MstRunNum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\MstRunNum findOrCreate($search, callable $callback = null, $options = [])
 */
class MstRunNumsTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('mst_run_nums');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

       
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
     public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->uuid('id')
            ->allowEmpty('id', 'create');

        $validator
            ->scalar('val_char')
            ->maxLength('val_char', 50)
            ->requirePresence('val_char', 'create')
            ->notEmpty('val_char');

        $validator
            ->scalar('val_value')
            ->maxLength('val_value', 50)
            ->requirePresence('val_value', 'create')
            ->notEmpty('val_value');

        return $validator;
    }

    
}
