<?php
declare(strict_types=1);

namespace UserPriviledges\Controller;

use App\Controller\AppController;
use Cake\Auth\DefaultPasswordHasher;

/**
 * Users Controller
 *
 */
class UsersController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
        $this->fetchTable('UserPriviledges.Users');
        $this->Authentication->allowUnauthenticated(['login']);

    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'User Managemet';
        $data['titleMenu'] = 'Data User';

       $this->paginate = [
            'limit' => 10,
            'order' => [
                'created' => 'desc',
            ],
        ];
        $user = $this->paginate($this->Users);
        $this->set(compact('data','user'));
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $user = $this->Users->get($id, contain: []);
        $this->set(compact('user'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'User Managemet';
        $data['titleMenu'] = 'Data User';
        $user = $this->Users->newEmptyEntity();
        if ($this->request->is('post')) {
            $user = $this->Users->patchEntity($user, $this->request->getData());
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $BranchnModel = $this->fetchTable('UserPriviledges.Branches');
        $branches = $BranchnModel
                    ->find('list',
                        keyField : 'id',
                        valueField : 'name'
                    )
                    ->toArray();
        $groupsModel = $this->fetchTable('UserPriviledges.Groups');
        $groups = $groupsModel
                    ->find('list',
                        keyField : 'id',
                        valueField : 'title'
                    )
                    ->toArray();            
                    
        

        $this->set(compact('user','data','branches','groups'));
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'User Managemet';
        $data['titleMenu'] = 'Edit Data User';
        $user = $this->Users->get($id, contain: ['Groups']);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $user = $this->Users->patchEntity($user, $this->request->getData());
            if ($this->Users->save($user)) {
                $this->Flash->success(__('The user has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The user could not be saved. Please, try again.'));
        }
        $BranchnModel = $this->fetchTable('UserPriviledges.Branches');
        $branches = $BranchnModel
                    ->find('list',
                        keyField : 'id',
                        valueField : 'name'
                    )
                    ->toArray();
        $groupsModel = $this->fetchTable('UserPriviledges.Groups');
        $groups = $groupsModel
                    ->find('list',
                        keyField : 'id',
                        valueField : 'title'
                    )
                    ->toArray();                
        $this->set(compact('user','data','branches','groups'));
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $user = $this->Users->get($id);
        if ($this->Users->delete($user)) {
            $this->Flash->success(__('The user has been deleted.'));
        } else {
            $this->Flash->error(__('The user could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    public function login(){

        $this->viewBuilder()->setLayout('login');
        $this->request->allowMethod(['get', 'post']);
        $result = $this->Authentication->getResult();

        // regardless of POST or GET, redirect if user is logged in
        if ($result && $result->isValid()) {

            $user = $result->getData();
            // Write user data to the session
           
            $getDetailUser = $this->Users->find()->contain(['Groups','Branches','Regions'])->where(['id'=>$user['id']])->first()->toArray();
          
            $getCompanies = $this->fetchTable('SystemConfigurations.Companies')->find()->first()->toArray();;
            $user->branch_code = $getDetailUser['branches'][0]['branch_code'];
            $user->branch_id = $getDetailUser['branches'][0]['id'];
            $user->company_name =$getCompanies['name'];
            $user->company_code =$getCompanies['company_code']; 
            $user->company_address =$getCompanies['address']; 
            $user->groups=$getDetailUser['groups'];
             //get Menu priviledge User
            $groups_id=[];
            $groups_name=[];
            foreach($getDetailUser['groups'] as $v){

                $groups_id[]=$v['id'];
                $groups_name[]=$v['title'];
            }

            $list_menus_priviledges = $this->fetchTable('UserPriviledges.GroupsMenus')->find('list',[
                'keyField' => 'menu_id',
                'valueField' => 'menu_id'
            ])->where(['group_id in '=>$groups_id])->toArray();

            $user->menus_priviledges = $list_menus_priviledges;
            //dd($list_menus_priviledges);
            
            $user->groups_name=$groups_name;
            // dd($user);
            $this->getRequest()->getSession()->write('Auth', $user);
            $redirect = $this->request->getQuery('redirect', [
                'plugin' => 'SystemConfigurations',
                'controller' => 'Home',
                'action' => 'index',
            ]);

            return $this->redirect($redirect);
        }
        // display error if user submitted and authentication failed
        if ($this->request->is('post') && !$result->isValid()) {
            $this->Flash->error(__('Invalid username or password'));
        }
    }
    public function logout()
    {
        $result = $this->Authentication->getResult();
        // regardless of POST or GET, redirect if user is logged in
        if ($result && $result->isValid()) {
            $this->Authentication->logout();
            return $this->redirect(['plugin'=>'UserPriviledges','controller' => 'Users', 'action' => 'login']);
        }
    }


    public function changepassword(){
        $data['titlePage'] = 'User Managemet';
        $data['titleMenu'] = 'Change  Password';
        if($this->request->is('post')){

            if(!$this->request->getData('currentpassword') or !$this->request->getData('newpassword') or !$this->request->getData('newpasswordconfirm')){
                
                $this->Flash->error(__('Please fill the field below'));
            }elseif($this->request->getData('newpassword') <> $this->request->getData('newpasswordconfirm')){
                
                $this->Flash->error(__('Your new password and re new password not equal'));
            }else{
               
                $userId = $this->getRequest()->getSession()->read('Auth.id');
                $user = $this->Users->get($userId);
                
                // Check current password
                if (!password_verify($this->request->getData('currentpassword'), $user->password)) {
                    $this->Flash->error(__('Your current password is incorrect'));
                } else {
                    // Hash the new password
                    $user->password = $this->request->getData('newpassword');
                    
                    if ($this->Users->save($user)) {
                        $this->Flash->success(__('Your password has been updated successfully'));
                        return $this->redirect(['plugin'=>'UserPriviledges','controller' => 'Users', 'action' => 'logout']);
                    } else {
                        $this->Flash->error(__('Unable to update your password. Please, try again.'));
                    }
                }

            }
        }
        $this->set(compact('data'));
    }

    public function profile(){

    }
}
