<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\User[]|\Cake\Collection\CollectionInterface $users
 */
?>

<section class="content-header">
  <h1>PKB</h1>
  <div class="breadcrumbs">
    <a href="#"><i class="fa fa-home"></i> Home</a> &raquo; Index

  </div>
  <div class="action-top">
    <?= $this->Html->link(__('Add'), ['action' => 'add'],['id'=>'btnAdd','class'=>'btn btn-danger btn-sm btn-add']) ?>
    
  </div>

  <?php if(($this->request->session()->read('Flash'))){?>
  <div class="row">
    <div class="col-md-12">
      <div class="alert alert-danger" role="alert">
        <a href="#" style="text-decoration:none;color:#FFF" class="close" data-dismiss="alert">&times;</a>
        <?= $this->Flash->render() ?>
      </div>
     </div>
   </div>
  <?php } ?>
  <div class="row">
       <div class="col-md-12">
           <div class="box box-default  collapsed-box" style="margin-bottom: 0px">
            <div class="box-header with-border">
              <h3 class="box-title">Search Filtering</h3>
              <div class="box-tools pull-right">
                <button type="button" class="btn btn-box-tool" data-widget="collapse"><i class="fa fa-plus"></i>
                </button>
              </div>
              <!-- /.box-tools -->
            </div>
            <!-- /.box-header -->

            <?= $this->Form->create($pkbs,['class'=>'form-horizontal']) ?>
            <div class="box-body" >
                
                <div class="form-group">
					 <?php echo $this->Form->label('nopol', 'Nopol', ['class'=>'col-sm-2']);?>
					 <div class="col-sm-2">
                    <?php  echo $this->Form->control('filter.1.nopol.optOperator',['type'=>'select','options'=>['like'=>'like','='=>'='],'required'=>false,'class'=>'form-control','label'=>false]);?>
                    </div>
					 <div class="col-sm-4">
					     <?php  echo $this->Form->control('filter.1.nopol.fields',['required'=>false,'class'=>'form-control','placeholder'=>'Nomor Polisi','label'=>false]);?>
					 </div>
				</div>
				
				

                <div class="form-group">
                  <?php echo $this->Form->label('filter.0.kode_workshop.kode_workshop', 'No PKB', ['class'=>'col-sm-2']);?>
                  <div class="col-sm-2">
                    <?php  echo $this->Form->control('filter.0.kode_workshop.optOperator',['type'=>'select','options'=>['like'=>'like','='=>'='],'required'=>false,'class'=>'form-control','label'=>false]);?>
                  </div>
                  <div class="col-sm-4">
                    <?php  echo $this->Form->control('filter.0.kode_workshop.fields',['required'=>false,'class'=>'form-control','placeholder'=>'No PKB','label'=>false]);?>
                  </div>
                </div>

                
                <!--<div class="form-group">
                  <?php echo $this->Form->label('filter.2.trans_date', 'Invoice Date', ['class'=>'col-sm-2']);?>

                  <div class="col-sm-3">
                    <?php  echo $this->Form->control('filter.2.trans_date.fields0',['required'=>false,'class'=>'datepicker form-control','placeholder'=>'From','label'=>false]);?>
                  </div>
                  <div class="col-sm-3 col-offset-sm-4">
                    <?php  echo $this->Form->control('filter.2.trans_date.fields1',['required'=>false,'class'=>'datepicker  form-control','placeholder'=>'To','label'=>false]);?>
                  </div>
                </div>-->

                <div class="form-group">
                    <div class="col-md-4 col-md-offset-2">
                    <button type="submit" class="btn btn-primary">Filter</button>
                    </div>
                </div>
            </div>
            <?= $this->Form->end() ?>
            <!-- /.box-body -->
          </div>
       </div>
  </div>
</section>
<!-- Main content -->
    <section class="content">
      <div class="row">
        <div class="col-xs-12">
          <div class="box">
          <div class="box-header">
            <div class="menu-dropdown">
              <div class="btn-group">
                  <button type="button" class="btn btn-default dropdown-toggle"
                  data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                  Show / Hide columns <span class="caret"></span>
                  </button>
                  <ul class="dropdown-menu" style="padding-left:8px" id="listing-col">
                  <!--<li><input type="checkbox" id="listing-col-01" name="field-pkb-no"  class="toggle-vis" data-value="1" data-column="1"> Invoice No </li>
                  <li><input type="checkbox" id="listing-col-02" name="field-pkb-date" class="toggle-vis" data-value="2" data-column="2" checked="true"> Invoice Date </li>
                  -->
                  <li><a class="toggle-vis" data-column="1">Kode</a></li>
                  <li><a class="toggle-vis" data-column="2">Invoice Date</a></li>
                  <li><a class="toggle-vis" data-column="3">Nama</a></li>
                  <li><a class="toggle-vis" data-column="5">Created</a></li>

                  </ul>
              </div>

				    </div>
          </div>
          <!-- /.box-header -->
          <div class="box-body">
            <table id="data-tables" class="table table-bordered table-striped">
              <thead>
              <tr>
               
                <th>No PKB</th>
                <th>Tanggal</th>
                <th>Nama</th>
				<th>Nopol</th>
				<th>Lokasi</th>
				<th>Status</th>
                <!--<th>Created</th>-->
                <!--<th>Created by</th>-->
                <th class="no-sort">Action</th>
              </tr>
              </thead>
              <tbody>
                 

                <?php foreach ($pkbs as $pkb): ?>
            <tr>
                
                <td><?=  h($pkb->kode_workshop) ?></td>
                <td><?php echo  ($pkb->trans_date)?$pkb->trans_date->format('d F Y'):$pkb->trans_date ?></td>
                <td><?=  h($pkb->nama) ?></td>
				<td><?=  h($pkb->nopol) ?></td>
				<td><?=  h($pkb->lokasi) ?></td>
				
                <td><?php echo  ($pkb->payreceipt_no)?'<span class="label label-danger">Closed</span>':'<span class="label label-primary">Open</span>' ?></td>
				<!--<td><?php echo  ($pkb->created)?$pkb->created->format('d F Y'):$pkb->created ?></td>-->
				
				
				
                <td class="actions">
                    <button onclick="responsiveVoice.speak('Salam Satu Hati , Kepada Pelanggan atas nama <?=  strtolower(h($pkb->nama)) ?> , dengan nopol <?=  h($pkb->nopol) ?> , <?php echo  ($pkb->payreceipt_no)?'Mohon Segera Ke Kasir':'Mohon Segera Ke Frontdesk' ?>','Indonesian Female', {rate: 0.8});" 
type="button" value="Play" class="btn btn-primary btn-sm">Memanggil Pelanggan</button>

                    <?= $this->Html->link(__('View'), ['action' => 'view', $pkb->id],['class'=>'btn btn-default btn-sm']) ?>
                   <?= $this->Html->link(__('Edit'), ['action' => 'edit', $pkb->id],['class'=>'btn btn-default btn-sm']) ?>
                   
                </td>
            </tr>
                <?php endforeach; ?>
             
            </table>
          </div>
          <!-- /.box-body -->
             <div class="box-footer clearfix">
              <ul class="pagination pagination-sm no-margin pull-right">
                <?= $this->Paginator->first('<< ' . __('first')) ?>
                <?= $this->Paginator->prev('< ' . __('previous')) ?>
                <?= $this->Paginator->numbers() ?>
                <?= $this->Paginator->next(__('next') . ' >') ?>
                <?= $this->Paginator->last(__('last') . ' >>') ?>
            </ul>
            <p><?= $this->Paginator->counter(['format' => __('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')]) ?></p>
            </div>
        </div>
        <!-- /.box -->
        </div>
    </div>
</section>

<script src="https://code.responsivevoice.org/responsivevoice.js?key=QjVCrAc4"></script>

<script>
$(document).ready(function(){
  var table = $('#data-tables').DataTable({
    lengthMenu: [
       [ 10, 25, 50 ],
       [ '10 rows', '25 rows', '50 rows' ]
   ],
    dom: 'Bfrtip',
       buttons: [
          'pageLength', 'copy', 'csv', 'excel', 'pdf', 'print'
       ],
    "paging": false,   
    "info": false,   
/*buttons: {
        buttons: [
            { extend: 'copy', className: 'btn btn-primary' },
            { extend: 'excel', className: 'excelButton' }
        ]
    },
    */
   
    order: false			,
    columnDefs: [ { orderable: false, targets: [7] } ],
  });
  table.buttons().container()
        .appendTo( '#example_wrapper .col-sm-6:eq(0)' );
  $('.toggle-vis').on( 'click', function (e) {
       var id;
       var id = $(this).attr('id');
       e.preventDefault();

       // Get the column API object
       var column = table.column( $(this).attr('data-column') );
       // Toggle the visibility
       column.visible( ! column.visible() );
       console.log(column.visible());
       console.log(id);
       //checked unchecked
       /*
       if( column.visible()===true ) $( '#'+id ).prop( 'checked',true );
       else { alert('invisible') ; $( '#'+id ).prop( 'checked',false );  document.getElementById(id).checked = false;}
       */
   } );
  $('.datepicker').datepicker({
    autoclose: true,
    format:"yyyy-mm-dd"
  });
  $("#btnDel").click(function(){
      var id='';
      $("input[name='pid[]']").each(function () {
         if ($(this).is(":checked")) {
          id +=$(this).val()+',';
         }
      });

      if(id.length >0)
      {
        if (confirm("Are you sure you want to delete?")) {
          id = id.substring(0,id.length-1);
          var form = $('<form/>', {id : 'indexForm', method : 'POST', style:'display: none'}).appendTo('body');
          form.attr('action', '<?php echo $this->Url->build('/', false)?>salespkbs/pkbs/delete');
          form.prepend('<input type="hidden" id="fileId" name="id" value="'+id+'" />');
          form.prepend($('<input />', {type: 'hidden', name: '_method', value: 'POST'}));
          form.submit();
        }else{
					alert('No data selected.');
				}
			  return false;
      }
  });
});
</script>
