<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;

class ReceivingPartsController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Penerimaan HLO';
        $data['titleMenu'] = 'Penerimaan HLO';
        $purchase = $this->fetchTable('Transactions.Purchases')
                    
                    ->find()->where(['type_transaction'=>'HLO','status_hlo'=>0])->contain(['PurchaseDetails'])->all();
                    
        $this->set(compact('purchase','data'));            


    }

    public function receive($id){
        $this->loadComponent('General');
        $data['titlePage'] = 'Penerimaan HLO';
        $data['titleMenu'] = 'Penerimaan HLO';
        $connection = ConnectionManager::get('default');
        $purchase = $this->fetchTable('Transactions.Purchases')
        ->find()
        ->where(['Purchases.id'=>$id])
        ->first();
        // dd($purchase->purchase_code);
        $receive = $this->fetchTable('Transactions.Receives')->newEmptyEntity();
        $receivingData =$connection->execute(
            "
            select purchase_code, partnumber, (select deskripsi from mst_parts where partnumber=partnumber limit 1) partdesc, (sum(beli)-sum(terima)) sisa from ( 

                select a.purchase_code, b.partnumber, sum(qty) beli, 0 terima from purchases a join purchase_details b on a.id=b.purchase_id where a.id='".$id."' group by a.purchase_code, b.partnumber 
                UNION ALL 
                select trx_code, part_no,0, sum(qty) from log_parts where trx_code='".$purchase->purchase_code."' ) a group by a.purchase_code, a.partnumber having (sum(beli)-sum(terima)) >0
            "

        )->fetchAll('assoc');
       
       // dd($receivingData);


        if($this->request->is('post')){
            
            $connection->begin();
            $receive = $this->fetchTable('Transactions.Receives')->patchEntity($receive, $this->request->getData());
            $receive->recv_code=$this->General->__sinchronizeID('TRM',date('ym'),5,array('val_id','val_char', 'val_value'));
            $receive->created = date('Y-m-d H:i:s');;
            $receive->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $receive->modified = date('Y-m-d H:i:s');
            $receive->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            $receive->branch_id = $this->getRequest()->getSession()->read('Auth.branch_id');
            $receive->branch_code = $this->getRequest()->getSession()->read('Auth.branch_code');

            $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code'=>$receive->branch_code])->select(['id','kode_gudang','nama_gudang'])->first(); 
            $receive->warehouse_code = $getwarehouseID->kode_gudang;
            $receive->warehouse_id = $getwarehouseID->id;

           
           
            
           
            if($receive){
                $transLog=[];
               
                $getrak = $this->fetchTable('Masters.Raks')->find()->where(['branch_code'=>$purchase->branch_code])->select(['id','rak_code'])->first();  
                $qty=0;
                $qty_terima=0;
                foreach($receive->receive_details as $i=>$v){
                    $qty = $qty +  $v->qty ;
                    $qty_terima = $qty_terima + $v->qty_terima;
                    $receive->receive_details[$i]->branch_code = $receive->branch_code;
                    $receive->receive_details[$i]->branch_id = $receive->branch_id;                
                    $receive->receive_details[$i]->recv_code = $receive->recv_code;   
                    $receive->receive_details[$i]->rak = $getrak->rak_code;
                    $receive->receive_details[$i]->warehouse_code = $receive->warehouse_code;
                    $receive->receive_details[$i]->warehouse_id = $receive->warehouse_id;
                    $receive->receive_details[$i]->created = date('Y-m-d H:i:s');;
                    $receive->receive_details[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $receive->receive_details[$i]->modified = date('Y-m-d H:i:s');
                    $receive->receive_details[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');

                    $transLog[$i]['trx_code'] = $receive->recv_ref;
                    $transLog[$i]['trx_date'] = date('Y-m-d H:i:s');
                    $transLog[$i]['part_no'] =  $v->partnumber;
                    $transLog[$i]['part_name'] = $v->partdesc;
                    $transLog[$i]['in_out'] = 'I';
                    $transLog[$i]['qty'] = $v->qty_terima;
                    $transLog[$i]['warehouse_code'] = $getwarehouseID->kode_gudang;
                    $transLog[$i]['warehouse_id'] = $getwarehouseID->id;
                    $transLog[$i]['rak_code'] = $getrak->rak_code;
                    $transLog[$i]['rak_id'] = $getrak->id;
                    $transLog[$i]['branch_code'] = $receive->branch_code;
                    $transLog[$i]['branch_id'] = $receive->branch_id;

                    $logpartTable = $this->fetchTable('Transactions.LogParts');
                    $logs = $logpartTable->newEntities($transLog);
                    $resulLogs = $logpartTable->saveMany($logs);
                    if($resulLogs){
                        $parttable = $this->fetchTable('Transactions.StockParts');
                        $getStocks = $parttable->find()->where(['partnumber'=>$v->partnumber,'rak'=>$getrak->rak_code,'warehouse_code'=>$getwarehouseID->kode_gudang])->first();

                        if($getStocks){
                                 //update
                          $getStocks->qty = $getStocks->qty + $v->qty_terima; 
                          if(!$parttable->save($getStocks)){
                                $setStatus = 0;
                                $message = 'Fail update stocks. Please, try again.';
                                break;
                          }      
                       }else{
                            $mstStock['warehouse_code'] = $getwarehouseID->kode_gudang;
                            $mstStock['warehouse_name'] = $getwarehouseID->nama_gudang;
                            $mstStock['rak_id'] = $getrak->id;
                            $mstStock['rak'] = $getrak->rak_code;;
                            $mstStock['partnumber'] = $v->partnumber;
                            $mstStock['partdesc'] = $v->partdesc;
                            $mstStock['qty'] = $v->qty_terima;
                            $mstStock['harga'] = 0;
                            $mstStock['created'] = date('Y-m-d H:i:s');;
                            $mstStock['create_by'] = $this->getRequest()->getSession()->read('Auth.id');
                            $mstStock['modified'] = date('Y-m-d H:i:s');
                            $mstStock['modi_by'] = $this->getRequest()->getSession()->read('Auth.id');

                            $stocks = $parttable->newEntity($mstStock);
                            if(!$parttable->save($stocks)){
                                  $setStatus = 0;
                                  $message = 'Fail update stocks. Please, try again.';
                                  break;
                            }else{
                                $setStatus = 1;
                                $message = 'The data has been saved.';
                            }
                       }

                    }else{
                        $setStatus = 0;
                        $message = 'The log parts could not be saved. Please, try again.';
                        break;
                    }   


                }


                if ($this->fetchTable('Transactions.Receives')->save($receive)) {
                    $setStatus = 1;
                    $message='The data has been saved.';
                }else{
                    $setStatus=0;
                    $message='The data could not be saved. Please, try again.';
                }


                if($qty == $qty_terima){

                
                    $updateStatus = $this->fetchTable('Transactions.Purchases')->updateALL(['status_hlo'=>1],['Purchases.id'=>$id]);
                    if(!$updateStatus){
                        $setStatus = 0;
                        $message = 'The HLO could not be saved. Please, try again.';
                    }else{
                        $setStatus = 1;
                        $message = 'The data has been saved.';
                    }
                }    
                $this->Flash->set(__($message));

                if($setStatus){
                    $connection->commit();
                }else {
                    $connection->rollback();
                }
                 return $this->redirect(['action' => 'index']);

            }
        }
        $this->set(compact('data','purchase','receivingData','receive'));
    }

    public function view($id){
        $data['titlePage'] = 'View Faktur Pembelian HLO';
        $data['titleMenu'] = 'View Data Faktur Pembelian';
        $purchase = $this->fetchTable('Transactions.Purchases')->get($id, contain: ['PurchaseDetails']);
        $this->set(compact('data','purchase'));
    }
}