<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;

class PurchasesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Pembelian';
        $data['titleMenu'] = 'Data Pembelian';


        $query = $this->Purchases->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'purchase_code LIKE' => '%' . $search . '%',
                    'supplier_code LIKE' => '%' . $search . '%',
                    'type_transaction LIKE' => '%' . $search . '%',
                    'purchase_date' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Purchases.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Purchases.created desc');
        
        $purchase = $this->paginate($query);
        
        $this->set(compact('data','purchase'));
    }
    public function add(){
        $data['titlePage'] = 'Pembelian';
        $data['titleMenu'] = 'Add Data Pembelian';
        $this->loadComponent('General');
        $setStatus = 1;
        $purchase = $this->Purchases->newEmptyEntity();
        if ($this->request->is('post')) {
            //dd($purchase);
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $purchase = $this->Purchases->patchEntity($purchase, $this->request->getData());
           
            $purchase->purchase_code=$this->General->__sinchronizeID('PRC',date('ym'),5,array('val_id','val_char', 'val_value'));
            $purchase->total = $this->General->__sinchronizecurrency($purchase->total);
            $purchase->grand_total = $this->General->__sinchronizecurrency($purchase->grand_total);
            $purchase->ppn = $this->General->__sinchronizecurrency($purchase->ppn);
            $purchase->diskon = $this->General->__sinchronizecurrency($purchase->diskon);
            $purchase->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $purchase->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            $supplierTable = $this->fetchTable('Masters.Suppliers');
            $supplier = $supplierTable->find()->where(['supplier_code'=>$purchase->supplier_code])->first();
                
            $purchase->supplier_id = $supplier->id;
            $getBranchID = $this->getRequest()->getSession()->read('Auth.branch_id');
            $purchase->branch_id= $getBranchID;
            $purchase->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');
                  $tqty=0;
                  //dd( $purchase);
            $transLog = [];   

            $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code'=>$purchase->branch_code])->select(['id','kode_gudang','nama_gudang'])->first();  
            $getrak = $this->fetchTable('Masters.Raks')->find()->where(['branch_code'=>$purchase->branch_code])->select(['id','rak_code'])->first();     
            foreach ($purchase->purchase_details as $i => $v) {
                if($v->partnumber and $v->qty){
                    $purchase->purchase_details[$i]->purchase_code = $purchase->purchase_code;
                    $purchase->purchase_details[$i]->qty = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->qty);
                    $purchase->purchase_details[$i]->price = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->price);
                    $purchase->purchase_details[$i]->disc_price = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->disc_price);
                    $purchase->purchase_details[$i]->disc_prosen = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->disc_prosen);
                    $purchase->purchase_details[$i]->total = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->total);
                    $purchase->purchase_details[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $purchase->purchase_details[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                    $purchase->purchase_details[$i]->created = date("Y-m-d h:i:s");
                    $purchase->purchase_details[$i]->modified = date("Y-m-d h:i:s");
                    
                    $tqty = $tqty + $this->General->__sinchronizecurrency($v->qty);

                    $purchase->purchase_details[$i]->branch_code = $purchase->branch_code;
                    $purchase->purchase_details[$i]->branch_id = $purchase->branch_id;

                    
                    $transLog[$i]['trx_code'] = $purchase->purchase_code;
                    $transLog[$i]['trx_date'] = date('Y-m-d H:i:s');
                    $transLog[$i]['part_no'] =  $v->partnumber;
                    $transLog[$i]['part_name'] = $v->partdesc;
                    $transLog[$i]['in_out'] = 'I';
                    $transLog[$i]['qty'] = $this->General->__sinchronizecurrency($v->qty);
                    $transLog[$i]['warehouse_code'] = $getwarehouseID->kode_gudang;
                    $transLog[$i]['warehouse_id'] = $getwarehouseID->id;
                    $transLog[$i]['rak_code'] = $getrak->rak_code;
                    $transLog[$i]['rak_id'] = $getrak->id;
                    $transLog[$i]['branch_code'] = $purchase->branch_code;
                    $transLog[$i]['branch_id'] = $purchase->branch_id;
                }    
            }
            $purchase->tqty = $tqty;
                  
            if($setStatus){
                $result = $this->Purchases->save($purchase,[ 'associated' => ['PurchaseDetails']]);
                if ($result) {
                    //simpan jadi stok

                    if($purchase->type_transaction == 'Reguler')
                    {    
                        if($transLog){
                            $logpartTable = $this->fetchTable('Transactions.LogParts');
                            $logs = $logpartTable->newEntities($transLog);
                            $resulLogs = $logpartTable->saveMany($logs);
                            if($resulLogs){
                             //update stok
                                $parttable = $this->fetchTable('Transactions.StockParts');
                                foreach ($transLog as $i => $v) {
                                  $getStocks = $parttable->find()->where(['partnumber'=>$v['part_no'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                                  //dd($v);
                                  $getStocks->qty = $getStocks->qty + $v['qty']; 
                                  if(!$parttable->save($getStocks)){
                                        $setStatus = 0;
                                        $message = 'Fail update stocks. Please, try again.';
                                        break;
                                  }else{
                                        $setStatus = 1;
                                        $message = 'The data has been saved.';
                                  }
                                }
                            }else{
                                $setStatus = 0;
                                $message = 'The log parts could not be saved. Please, try again.';
                            }
                        }
                    }else{
                         $setStatus = 1;
                        $message = 'The data has been saved.';
                    }    
                          
                }else{
                  $setStatus = 0;
                  $message = 'The data Purchase could not be saved. Please, try again.';
                }
            }



            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }


        }

        $supplierTable = $this->fetchTable('Masters.Suppliers');
        $suppliers = $supplierTable
                    ->find('list',
                        keyField : 'supplier_code',
                        valueField : 'name'
                    )
                    ->toArray();

       
                            
        $this->set(compact('purchase','suppliers'));
        $this->set('_serialize', ['purchase']);            
    }
    public function getpartdetail(){
        $this->autoRender = false;
        $keyword = $this->request->getQuery('term');

        $parttable = $this->fetchTable('Masters.Parts');
        
        $suggestions = $parttable
            ->find('list',
            keyField : 'deskripsi',
            valueField : 'partnumber'
            )->where(['partnumber LIKE' => '%' . $keyword . '%'])
            ->toArray();

        foreach($suggestions as $i=>$v){
            $result[$i] = ['id'=>$i,'label'=>$v,'value'=>$v];
        }
        echo json_encode($result);
        exit;
    }


    function batal($id){
        $this->request->allowMethod(['post', 'delete']);
        $connection = ConnectionManager::get('default');
        $connection->begin();
        $data = $this->Purchases->get($id,
            contain : ['PurchaseDetails']
        );
        if($data->status == 1){
            $this->Flash->success(__('Faktur Pembelian  '.$data->purchase_code.' sudah dibatalkan sebelumnya.'));
            return $this->redirect(['action' => 'index']);
        }
        $data->status = 1;
        $update = $this->Purchases->save($data);
        if ($update) {
            //add log trans
            $logpartTable = $this->fetchTable('Transactions.LogParts');
            foreach($data->invoice_parts as $i=>$v){
                
                $entLog = $logpartTable->newEmptyEntity();

                $entLog->trx_code = $data->purchase_code;
                $entLog->trx_date = $data->purchase_date;
                $entLog->part_no = $v->partnumber;
                $entLog->part_name = $v->partdesc;
                $entLog->in_out = 'O';
                $entLog->qty = $v->qty;
                $entLog->warehouse_code = $v->warehouse_code;
                $entLog->warehouse_id = $v->warehouse_id;
                $entLog->rak_code = $v->rak_code;
                $entLog->rak_id = $v->rak_id;
                $entLog->branch_id = $v->branch_id;
                $entLog->branch_code = $v->branch_code;
                $resulLogs = $logpartTable->save($entLog);
                if(!$logpartTable->save($entLog)){
                   
                    $setStatus = 0;
                    $message = 'Fail add log partnumber. Please, try again.';
                }else{
                    
                      //update mst stok
                      $parttable = $this->fetchTable('Transactions.StockParts');
                      $getStocks = $parttable->find()->where(['partnumber'=>$v['partnumber'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                              //dd($v);
                      $getStocks->qty = $getStocks->qty - $v['qty']; 
                      if(!$parttable->save($getStocks)){
                            $setStatus = 0;
                            $message = 'Fail update stocks. Please, try again.';
                            break;
                      }else{
                            $setStatus = 1;
                            $message = 'The data has been saved.';
                      }
                }


            }
          
            $connection->commit();
            $this->Flash->success(__('Faktur Pembelian sudah dibatalkan.'));
        } else {
            $connection->rollback();
            $this->Flash->error(__('Faktur Pembelian  gagal dibatalkan. Silakan mencoba kembali.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function view($id = null)
    {
        $data['titlePage'] = 'Faktur Pembelian';
        $data['titleMenu'] = 'View Data Faktur Pembelian';
        $purchase = $this->Purchases->get($id, contain: ['PurchaseDetails']);
        $this->set(compact('data','purchase'));
    }
}
