<?php
namespace SystemConfigurations\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * Companies Controller
 *
 * @property \App\Model\Table\CompaniesTable $Companies
 *
 * @method \App\Model\Entity\Company[] paginate($object = null, array $settings = [])
 */
class MenusController extends AppController
{
	// In a controller action
	public function index()
	{
		$data['titlePage'] = 'Menu';
        $data['titleMenu'] = 'List Menu';
	    $menuItems = $this->Menus->find('treeList', ['spacer' => '--'])->toArray();

	    $this->set(compact('menuItems','data'));
	}

	public function add(){
		$data['titlePage'] = 'Menu';
        $data['titleMenu'] = 'Data Menu';
        $menu = $this->Menus->newEmptyEntity();
        $parentMenu = $this->Menus->find('treeList', ['spacer' => '--'])->toArray();
        if ($this->request->is('post')) {
            $menu = $this->Menus->patchEntity($menu, $this->request->getData());
            $menu->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $menu->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Menus->save($menu)) {
                $this->Flash->success(__('The Menus has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The Menus could not be saved. Please, try again.'));
        }
        $this->set(compact('menu','data','parentMenu'));
	}

	 public function edit($id = null)
    {
        $data['titlePage'] = 'Menu';
        $data['titleMenu'] = 'Data Menu';
        $menu = $this->Menus->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $menu = $this->Menus->patchEntity($menu, $this->request->getData());
            $menu->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Menus->save($menu)) {
                $setStatus = 1;
                $message = 'The menu has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The menu could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        
       
        $parentMenu = $this->Menus->find('treeList', ['spacer' => '--'])->toArray();
        $this->set(compact('menu','parentMenu','data'));
        $this->set('_serialize', ['menu']);
    }
    public function delete($id = null)
	{
	    $this->request->allowMethod(['post', 'delete']);
	    $menu = $this->Menus->get($id);
	    if ($this->Menus->delete($menu)) {
	        $this->Flash->success(__('The menu item has been deleted.'));
	    } else {
	        $this->Flash->error(__('The menu item could not be deleted. Please, try again.'));
	    }
	    return $this->redirect(['action' => 'index']);
	}

}