<?php
declare(strict_types=1);

namespace SystemConfigurations\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;

class HomeController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);


    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Dashboard';
        $conn = ConnectionManager::get('default');

        $startDate = date('Y-m-01');
        $endDate = date('Y-m-t');


        $dataparts = $conn->execute("select month(trans_date) day, sum(total_harga) total from workshops a join workshops_dtlparts b on a.id = b.workshop_id where year(trans_date) ='".date('Y')."' group by month(trans_date) ");
        $datapart = $dataparts->fetchAll('assoc');  

        $nparts = []; // Inisialisasi array $npart
        foreach($datapart as $i => $v){
            $v['day'] = (int) $v['day'];
            $nparts[$v['day']] = (int) $v['total'];
        }
        
        $m = 0;
        for ($n = 1; $n <= 12; $n++) {
            if (!isset($nparts[$n])) {
                $npart[(int)$m] = 0;
            } else {
                $npart[(int)$m] = $nparts[$n];
            }
            $m++;
        }


        $jasas = $conn->execute("select month(trans_date) day, sum(total_harga) total from workshops a join workshops_dtlservices b on a.id = b.workshop_id where year(trans_date) ='".date('Y')."' group by month(trans_date)");


        $jasa = $jasas->fetchAll('assoc');  

        $njasas=[];
        foreach($jasa as $i=>$v){
            $v['day'] = (int)$v['day'];
            $njasas[$v['day']] = (int)$v['total'];
        }
        

        $m = 0;
        for ($n = 1; $n <= 12; $n++) {
            if (!isset($njasas[$n])) {
                $njasa[(int)$m] = 0;
            } else {
                $njasa[(int)$m] = $njasas[$n];
            }
            $m++;
        }
    

        //count workshops
        $getUnitEntryMonth = $this->fetchTable('Transactions.Invoices')->find()->where(["trans_date between '$startDate' and '$endDate' "])->count();
        $getUnitEntryDaily = $this->fetchTable('Transactions.Invoices')->find()->where(["trans_date between '".date('Y-m-d 00:00:00')."' and '".date('Y-m-d 23:59:59')."' "])->count();
        // $query =  $this->fetchTable('Transactions.InvoiceParts')->find()->where(["created between '$startDate' and '$endDate' "])

        //              ->select(['total_harga' => $query->func()->sum('total_harga')]);
        // $getPart = $query->all();


       

         $getParts =  $conn->execute("
           
            select  sum(total_harga) total from workshops_dtlparts   where created between '".$startDate."' and '".$endDate."' 
           

            ");

         $getPart = $getParts->fetchAll('assoc'); 

         $getJasas =  $conn->execute("
           
            select  sum(total_harga) total from workshops_dtlservices   where created between '".$startDate."' and '".$endDate."' 
           

            ");

         $getJasa = $getJasas->fetchAll('assoc');
        
        if($getJasa[0]['total']==null){
            $getJasa[0]['total']=0;
        }
        if($getPart[0]['total']==null){
            $getPart[0]['total']=0;
        }

        //top salesman
        $topsalesmans =  $conn->execute("
           select mekanik, nama_mekanik, total from ( 
            select mekanik, count(id) total from workshops  where trans_date between '".$startDate."' and '".$endDate."' group by mekanik
            ) a join mst_employes b on b.employee_code = a.mekanik order by total desc limit 10

            ");
        $topsalesman = $topsalesmans->fetchAll('assoc'); 


        //top CUSTOMER
        $topcustomers =  $conn->execute("
           select a.nopol, a.nama, total from ( 
            select nopol,nama, count(id) total from workshops  where trans_date between '".$startDate."' and '".$endDate."' group by nopol
            ) a join mst_customers b on b.nopol = a.nopol order by total desc limit 10

            ") ;
        $topcustomer = $topcustomers->fetchAll('assoc');  


        //top part
        $topParts = $conn->execute("
            select partnumber,partdesc,total from(
            select partnumber,partdesc,sum(qty) total from workshops a join workshops_dtlparts b on a.id = b.workshop_id where trans_date between '".$startDate."' and '".$endDate."'  group by partnumber 
            ) a order by total desc limit 10
            ");
        $topPart = $topParts->fetchAll('assoc'); 
      
        $partSeries=[];
        $partlabel=[];
        if($topPart){
            foreach($topPart as $i=>$v){
                $partSeries[]=(int)$v['total'];
                $partlabel[]=$v['partdesc'];
            }
        }
// dd($this->getRequest()->getSession()->read('Auth.groups.0.title'));
        $this->set(compact('data','njasa','npart','getUnitEntryMonth','getUnitEntryDaily','getPart','getJasa',
        'topsalesman','topPart','partSeries','partlabel','topcustomer'));

        if($this->getRequest()->getSession()->read('Auth.groups.0.title')=='Manager'){
            $this->render('home_manager');
        }else{
            $this->render('index');
        }


        
    }



}
