<?php
namespace SystemConfigurations\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * Companies Controller
 *
 * @property \App\Model\Table\CompaniesTable $Companies
 *
 * @method \App\Model\Entity\Company[] paginate($object = null, array $settings = [])
 */
class CompaniesController extends AppController
{
    /**
     * Edit method
     *
     * @param string|null $id Company id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit()
    {
        $data['titlePage'] = 'Company';
        $data['titleMenu'] = 'Data Company';
        $setStatus = 1;
        $getCompany = $this->Companies->find()->select('id')->first();
        $company = $this->Companies->get($getCompany->id);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $company = $this->Companies->patchEntity($company, $this->request->getData());
            if ($this->Companies->save($company)) {
                $setStatus = 1;
                $message = 'The company has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The company could not be saved. Please, try again.';
            }
            if($setStatus){
                $connection->commit();
            }else {
                $connection->rollback();
            }
            $this->Flash->set(__($message));
            return $this->redirect(['action' => 'edit']);
        }
        $this->set(compact('company','data'));
        $this->set('_serialize', ['company']);
    }

}
