<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportSalesPiutangsController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {

     $conn = ConnectionManager::get('default');
     $data['titlePage'] = 'Report Piutang Bengkel';
     $data['titleMenu'] = 'Report Piutang Bengkel';
      if ($this->request->is('post')) { 
          $dataTable = $this->fetchTable('Transactions.Invoices');
          $results = $dataTable->find()
                  ->where(function ($exp, $q) {
                      return $exp->between('trans_date', $this->request->getData('start'), $this->request->getData('end'))
                       ->eq('tipe_bayar', 4)
                      ;
                    })
          ->contain(['InvoiceJasas'])
          ->order(['kode_workshop'=>'asc'])
                  ->all();
      
          
      $dataReports=[];  
      $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');
      $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');
     
     $start = $this->request->getData('start');
     $end = $this->request->getData('end');
     
      $result =$conn->execute(" SELECT a.kode_workshop, a.trans_date, a.nopol, a.nama, a.no_tlp, 
      a.mekanik, a.nama_mekanik, b.nama_jasa, sum(b.harga) harga_jasa, sum(b.diskon) diskon_jasa, 
      sum(b.total_harga) total_jasa, c.partnumber, c.partdesc, sum(c.qty) qty_part, sum(c.price) harga_part, 
      sum(c.diskon) diskon_part, sum(c.total_harga) total_part 
      FROM workshops a LEFT JOIN workshops_dtlservices b ON (a.id=b.workshop_id) 
      LEFT JOIN workshops_dtlparts c ON(a.id=c.workshop_id) WHERE a.trans_date >= '".$start."'
       AND a.trans_date <= '".$end."'  
       and a.tipe_bayar=4
                                    GROUP BY a.kode_workshop
                                    ORDER BY a.kode_workshop ASC;
                               ");
      $result = $result->fetchAll('assoc');  
   
      
      if(empty($result)){
        $this->Flash->set(__('Data tidak tersedia.'));
        return $this->redirect(['action' => 'index']);
      }
          switch ($this->request->getData('type')) {
            case 'html':
              $file = 'html';
              break;
            case 'excel':
              $file = 'excel';
              break;
            case 'pdf':
              $file = 'pdf';
              break;
            default:
              $file = 'html';
              break;
          }
          $periode = date("d F Y",strtotime($this->request->getData('start'))).' - '.date("d F Y",strtotime($this->request->getData('end')));
          $this->set(compact('data','periode','company','result'));
          $this->render($file);
        }
         $this->set(compact('data'));
    }

}
