<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportHarianBengkelsController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {
        $conn = ConnectionManager::get('default');
        if ($this->request->is('post')) {
          $this->loadModel('Transactions.Pkbs');
          $datas =$conn->execute("
            select kode_workshop,trans_date,nopol,nama,no_tlp,alasan,type_jasa,lokasi,pay_type,sum(cash) cash,sum(credit) credit,sum(diskon) diskon,sum(total) total,nama_mekanik from(
                select kode_workshop,trans_date,a.nopol,a.nama,a.no_tlp,a.alasan,type_jasa,lokasi,c.pay_type,sum(c.price) cash,0 credit,sum(c.cash_disc) diskon,sum(c.total) total,d.nama_mekanik from workshops a join payreceipts b on a.kode_workshop = b.pkb_no
                join payreceipt_details c on c.payreceipt_id = b.id
                left join mst_employes d on a.mekanik=d.id
                where trans_date between '".$this->request->getData('start')."' and  '".$this->request->getData('end')."' and c.pay_type='CA'
                group by a.kode_workshop
                UNION ALL
                select kode_workshop,trans_date,a.nopol,a.nama,a.no_tlp,a.alasan,type_jasa,lokasi,c.pay_type,0 cash,sum(c.price) credit,sum(c.cash_disc),sum(c.total) ,d.nama_mekanik from workshops a join payreceipts b on a.kode_workshop = b.pkb_no
                join payreceipt_details c on c.payreceipt_id = b.id
                left join mst_employes d on a.mekanik=d.id
                where trans_date between '".$this->request->getData('start')."' and  '".$this->request->getData('end')."' and c.pay_type='CR'
                group by a.kode_workshop
                UNION ALL
                select a.directsales_code,directsales_date,'',a.customer_name,a.customer_phone,'DS','DS','',a.pay_type,sum(b.net_price),0,0,sum(b.net_price),''
                from direct_sales a join directsales_details b on a.id=b.directsales_id
                where directsales_date between '".$this->request->getData('start')."' and  '".$this->request->getData('end')."' 
                group by a.directsales_code
                ) a
                group by kode_workshop
                order by kode_workshop asc
            ");
          $data = $datas->fetchAll('assoc');  
         // dd($data);
          if(empty($datas)){
            $this->Flash->set(__('Data tidak tersedia.'));
            return $this->redirect(['action' => 'index']);
          } 
          switch ($this->request->data('type')) {
            case 'html':
              $file = 'html';
              break;
            case 'excel':
              $file = 'excel';
              break;
            case 'pdf':
              $file = 'pdf';
              break;
            default:
              $file = 'html';
              break;
          }
          $periode = date("d F Y",strtotime($this->request->data('start'))).' - '.date("d F Y",strtotime($this->request->data('end')));
          $this->set(compact('data','periode','datas'));
          $this->render($file);
        }
    }

}
