<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Http\Response;
use Cake\Utility\Security;
use Cake\Event\EventInterface;
/**
 * Customers Controller
 *
 * @property \Masters\Model\Table\CustomersTable $Customers
 *
 * @method \Masters\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class PartsController extends AppController
{
  

    public function initialize(): void
    {
        parent::initialize();
        // $this->loadMiddleware('RequestHandler');
    }


    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Data Part';

		$query = $this->Parts->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'partnumber LIKE' => '%' . $search . '%',
                    'deskripsi LIKE' => '%' . $search . '%',
                    'kel_barang LIKE' => '%' . $search . '%',
                    'harga' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Parts.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Parts.created desc');
        
		$parts = $this->paginate($query);

		//dd($getCookieCust);
		$this->set(compact('parts','data'));
		$this->set('_serialize', ['parts']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Data Part';
        $part = $this->Parts->get($id);

        $this->set(compact('part','data' ));
        $this->set('_serialize', ['part']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Data Part';
        $part = $this->Parts->newEmptyEntity();
        if ($this->request->is('post')) {
            $part = $this->Parts->patchEntity($part, $this->request->getData());
            if ($this->Parts->save($part)) {
                $this->Flash->success(__('The Parts has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The Parts could not be saved. Please, try again.'));
        }
        $this->set(compact('part','data'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Data Part';
        $part = $this->Parts->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $part = $this->Parts->patchEntity($part, $this->request->getData());
            $part->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Parts->save($part)) {
                $setStatus = 1;
                $message = 'The part has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The part could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        $motorModel = $this->fetchTable('Masters.Motorcycles');
        $getTypeMtr = $motorModel
                    ->find('list',
                        keyField : 'motor_code',
                        valueField : 'type_mtr'
                    )
                    ->toArray();

       
       
        $this->set(compact('part','getTypeMtr','data'));
        $this->set('_serialize', ['part']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $part = $this->Parts->get($id);
        if ($this->Parts->delete($part)) {
            $this->Flash->success(__('The Parts has been deleted.'));
        } else {
            $this->Flash->error(__('The Parts could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    function searchTypeMtr(){
        $this->viewBuilder()->setLayout(false);
        $this->loadModel('MasterFile.Motorcyles');
        $keyword = $_GET['search'];
        $getTypeMtr = $this->Motorcyles->find()->where([" type_mtr like '%".$keyword."%'",'status'=>'Y'])->select(['motor_code','type_mtr'])->all();
        foreach ($getTypeMtr as $i => $v) {
            $data[] = array('id'=>$v->motor_code,'text'=>$v->type_mtr);
        }
        $result = json_encode($data);
        $this->response->type('json');
        $this->response->body($result);
        return $this->response    ;
    }
    
    function getSparepart($partnumber){

        $parttable = $this->fetchTable('Masters.Parts');
        $getParts = $parttable->find()->where(['partnumber'=>$partnumber])
                        ->first();
        echo json_encode($getParts);
        exit;
    }

     function getpartdetail(){
        $this->viewBuilder()->setLayout(false);
        $keyword = $_GET['term'];
        $getpartnumber = $this->fetchTable('Masters.Parts')->find()->where([" partnumber like '%".$keyword."%'"])->select(['partnumber','partnumber'])->all();
        foreach ($getpartnumber as $i => $v) {
            $data[] = array('id'=>$v->partnumber,'text'=>$v->partnumber);
        }
       echo json_encode($data);
       exit;
    }
    function upload(){
        $data['titlePage'] = 'Master Part';
        $data['titleMenu'] = 'Tpload';
        $parttable = $this->fetchTable('Masters.Parts');
        $sparepart = $parttable->newEmptyEntity();
        $setStatus=1;
        $message = 'The data has been saved.';
        if($this->request->is('post')){
            $connection = ConnectionManager::get('default');
            $connection->begin();
            
            // $handle = fopen($this->request->getData('files')['tmp_name'], "r");


            $uploadedFile = $this->request->getData('files');
            $tempPath = $uploadedFile->getStream()->getMetadata('uri');

            $handle = fopen($tempPath, "r");

            $contents = [];
            while (!feof($handle)) {
                $line = fgets($handle);
                $temps = explode(";",$line);
                if($temps[0] != ''){
                    // dd($temps[0]);
                    $getPart = $parttable->find()->where(['partnumber'=>$temps[0]])->first();
                    // dd($getPart);
                    if($getPart){
                            
                            $getPart->harga = $temps[2];
                            $getPart->kel_barang = $temps[5];
                            //dd($parttable->save($getPart));
                             if(!$parttable->save($getPart)){
                                $setStatus = 0;
                                $message = 'Fail update part (row '.$temps[0].'). Please, try again.';
                                break;
                             }  
                        }else{
                            //insert partif

                                $mstStock['partnumber'] = $temps[0];
                                $mstStock['deskripsi'] = $temps[1];
                                $mstStock['harga'] = $temps[2];
                                $mstStock['kel_barang'] = $temps[5];
                                $mstStock['status'] = $temps[7];
                                
                                $mstStock['created'] = date('Y-m-d H:i:s');;
                                $mstStock['create_by'] = $this->getRequest()->getSession()->read('Auth.id');
                                $mstStock['modified'] = date('Y-m-d H:i:s');
                                $mstStock['modi_by'] = $this->getRequest()->getSession()->read('Auth.id');
                                //dd($mstStock);
                                $parts = $parttable->newEmptyEntity();
                                $parts = $parttable->patchEntity($parts, $mstStock);
                                if(!$parttable->save($parts)){
                                      $setStatus = 0;
                                      $message = 'Fail insert part (row '.($i+1).'). Please, try again.';
                                      break;
                                }else{
                                    $setStatus = 1;
                                    $message = 'The data has been saved.';
                                }
                        }

                }
            }


            
           
            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }

        }
        $this->set(compact('sparepart','data'));
        $this->set('_serialize', ['sparepart']);
     }

     public function ajaxGetData()
    {
        $this->request->allowMethod(['get']);
        // Get data
        $data = $this->paginate('Masters.Parts');

        $response = new Response();
        $response = $response->withStringBody(json_encode($data))
            ->withType('application/json')
            ->withHeader('Access-Control-Allow-Origin', '*'); // Optional: Allow cross-origin requests

        return $response;
    }

}
