<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\Core\Configure;
use Cake\Http\ServerRequest;
use Cake\ORM\TableRegistry;
/**
 * Customers Controller
 *
 * @property \Masters\Model\Table\CustomersTable $Customers
 *
 * @method \Masters\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class CorporatesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Perusahaan Konsumen';
        $data['titleMenu'] = 'Data Perusahaan Konsumen';
		  
        $query = $this->Corporates->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'name LIKE' => '%' . $search . '%',
                    'address LIKE' => '%' . $search . '%'
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Corporates.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Corporates.created desc');
        
        $corporates = $this->paginate($query);



		//dd($getCookieCust);
		$this->set(compact('corporates','data'));
		$this->set('_serialize', ['corporates']);
    }

    


    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $data['titlePage'] = 'Master Perusahaan Konsumen';
        $data['titleMenu'] = 'Data Perusahaan Konsumen';
        $corporates = $this->Corporates->get($id);

        $this->set(compact('corporates','data' ));
        $this->set('_serialize', ['corporates']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Perusahaan Konsumen';
        $data['titleMenu'] = 'Data Perusahaan Konsumen';
        $corporates = $this->Corporates->newEmptyEntity();
        $this->loadComponent('General');
        if ($this->request->is('post')) {
            $corporates = $this->Corporates->patchEntity($corporates, $this->request->getData());
           
            if ($this->Corporates->save($corporates)) {
                $this->Flash->success(__('The data has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The data could not be saved. Please, try again.'));
        }
        $this->set(compact('corporates','data'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Perusahaan Konsumen';
        $data['titleMenu'] = 'Data Perusahaan Konsumen';
        $corporates = $this->Corporates->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $corporates = $this->Corporates->patchEntity($corporates, $this->request->getData());
            $corporates->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Corporates->save($corporates)) {
                $setStatus = 1;
                $message = 'The data has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The data could not be saved. Please, try again.';
            }

            $this->Flash->error(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }

        //dd($getTypeMtr);
        $this->set(compact('corporates','data'));
        $this->set('_serialize', ['corporates']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $corporates = $this->Corporates->get($id);
        if ($this->Corporates->delete($corporates)) {
            $this->Flash->success(__('The data has been deleted.'));
        } else {
            $this->Flash->error(__('The data could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    

}
