<?php
declare(strict_types=1);

namespace UserPriviledges\Controller;

use App\Controller\AppController;

/**
 * Groups Controller
 *
 */
class GroupsController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
        $this->fetchTable('UserPriviledges.Groups');

    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Group';
        $data['titleMenu'] = 'Group';

       $this->paginate = [
            'limit' => 10,
            'order' => [
                'created' => 'desc',
            ],
        ];
        $group = $this->paginate($this->Groups);
        $this->set(compact('data','group'));
    }

    /**
     * View method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $user = $this->Groups->get($id, contain: []);
        $this->set(compact('group'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Group Managemet';
        $data['titleMenu'] = 'Group';
        $group = $this->Groups->newEmptyEntity();
        if ($this->request->is('post')) {
            $group = $this->Groups->patchEntity($group, $this->request->getData());
            if ($this->Groups->save($group)) {
                $this->Flash->success(__('The group has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The group could not be saved. Please, try again.'));
        }
        

        $this->set(compact('group','data'));
    }

    /**
     * Edit method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Group Managemet';
        $data['titleMenu'] = 'Edit Data Group';
        $group = $this->Groups->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $group = $this->Groups->patchEntity($group, $this->request->getData());
            if ($this->Groups->save($group)) {
                $this->Flash->success(__('The group has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The group could not be saved. Please, try again.'));
        }
        

        $this->set(compact('group','data'));
    }

    /**
     * Delete method
     *
     * @param string|null $id User id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $group = $this->Groups->get($id);
        if ($this->Groups->delete($group)) {
            $this->Flash->success(__('The group has been deleted.'));
        } else {
            $this->Flash->error(__('The group could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
    public function menuAccess($id){

        $data['titlePage'] = 'Menu Access';
        $data['titleMenu'] = 'Grant Menu Access';

        if ($this->request->is(['patch', 'post', 'put'])) {
            
            $n=0;
            foreach($this->request->getData('menutree') as $v){
                $groups[$n]['group_id']=$id;
                $groups[$n]['menu_id']=$v;
                $n++;
            }
            // dd($groups);
            //delete All

            $this->fetchTable('UserPriviledges.GroupsMenus')->deleteAll(['group_id'=>$id]);


            $groupsUsers = $this->fetchTable('UserPriviledges.GroupsMenus')->newEntities($groups);
            $results = $this->fetchTable('UserPriviledges.GroupsMenus')->saveMany($groupsUsers);
            // dd($results);
            if(!$results){
                $message ='The data could not be saved. Please, try again.';
            }else{
                $message='The data has been saved.';
            }

            $this->Flash->set(__($message));
            return $this->redirect(['action' => 'index']);

        }


        $menus = $this->fetchTable('SystemConfigurations.Menus');
        $GroupsMenus = $this->fetchTable('UserPriviledges.GroupsMenus');
        $this->set('listMenus', $menus->find('threaded')->where(['is_publish'=>1])->toArray());

        $permission = $GroupsMenus->find('list',[
            'keyField' => 'menu_id',
            'valueField' => 'menu_id'
        ])->where(['group_id'=>$id])->toArray();

        // dd($permission);

        $this->set('permission',$permission);
        $this->set('data',$data);
    }
    
}
