<?php
declare(strict_types=1);

namespace Transactions\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use Cake\ORM\TableRegistry;
use Cake\Log\Log;

class PurchasesController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $data['titlePage'] = 'Pembelian';
        $data['titleMenu'] = 'Data Pembelian';


        $query = $this->Purchases->find('all');

        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'purchase_code LIKE' => '%' . $search . '%',
                    'supplier_code LIKE' => '%' . $search . '%',
                    'type_transaction LIKE' => '%' . $search . '%',
                    'purchase_date' => $search,
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Purchases.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Purchases.created desc');
        
        $purchase = $this->paginate($query);
        
        $this->set(compact('data','purchase'));
    }
    public function add(){
        $data['titlePage'] = 'Pembelian';
        $data['titleMenu'] = 'Add Data Pembelian';
        $this->loadComponent('General');
        $setStatus = 1;
        $purchase = $this->Purchases->newEmptyEntity();
        if ($this->request->is('post')) {
            //dd($purchase);
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $purchase = $this->Purchases->patchEntity($purchase, $this->request->getData());
           
            $purchase->purchase_code=$this->General->__sinchronizeID('PRC',date('ym'),5,array('val_id','val_char', 'val_value'));
            $purchase->total = $this->General->__sinchronizecurrency($purchase->total);
            $purchase->grand_total = $this->General->__sinchronizecurrency($purchase->grand_total);
            $purchase->ppn = $this->General->__sinchronizecurrency($purchase->ppn);
            $purchase->diskon = $this->General->__sinchronizecurrency($purchase->diskon);
            $purchase->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $purchase->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            $supplierTable = $this->fetchTable('Masters.Suppliers');
            $supplier = $supplierTable->find()->where(['supplier_code'=>$purchase->supplier_code])->first();
                
            $purchase->supplier_id = $supplier->id;
            $getBranchID = $this->getRequest()->getSession()->read('Auth.branch_id');
            $purchase->branch_id= $getBranchID;
            $purchase->branch_code= $this->getRequest()->getSession()->read('Auth.branch_code');
                  $tqty=0;
                  //dd( $purchase);
            $transLog = [];   

            $getwarehouseID = $this->fetchTable('Masters.Warehouses')->find()->where(['branch_code'=>$purchase->branch_code])->select(['id','kode_gudang','nama_gudang'])->first();  
            $getrak = $this->fetchTable('Masters.Raks')->find()->where(['branch_code'=>$purchase->branch_code])->select(['id','rak_code'])->first();     
            foreach ($purchase->purchase_details as $i => $v) {
                if($v->partnumber and $v->qty){
                    $purchase->purchase_details[$i]->purchase_code = $purchase->purchase_code;
                    $purchase->purchase_details[$i]->qty = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->qty);
                    $purchase->purchase_details[$i]->price = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->price);
                    $purchase->purchase_details[$i]->disc_price = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->disc_price);
                    $purchase->purchase_details[$i]->disc_prosen = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->disc_prosen);
                    $purchase->purchase_details[$i]->total = $this->General->__sinchronizecurrency($purchase->purchase_details[$i]->total);
                    $purchase->purchase_details[$i]->create_by = $this->getRequest()->getSession()->read('Auth.id');
                    $purchase->purchase_details[$i]->modi_by = $this->getRequest()->getSession()->read('Auth.id');
                    $purchase->purchase_details[$i]->created = date("Y-m-d h:i:s");
                    $purchase->purchase_details[$i]->modified = date("Y-m-d h:i:s");
                    
                    $tqty = $tqty + $this->General->__sinchronizecurrency($v->qty);

                    $purchase->purchase_details[$i]->branch_code = $purchase->branch_code;
                    $purchase->purchase_details[$i]->branch_id = $purchase->branch_id;

                    
                    $transLog[$i]['trx_code'] = $purchase->purchase_code;
                    $transLog[$i]['trx_date'] = date('Y-m-d H:i:s');
                    $transLog[$i]['part_no'] =  $v->partnumber;
                    $transLog[$i]['part_name'] = $v->partdesc;
                    $transLog[$i]['in_out'] = 'I';
                    $transLog[$i]['qty'] = $this->General->__sinchronizecurrency($v->qty);
                    $transLog[$i]['warehouse_code'] = $getwarehouseID->kode_gudang;
                    $transLog[$i]['warehouse_id'] = $getwarehouseID->id;
                    $transLog[$i]['rak_code'] = $getrak->rak_code;
                    $transLog[$i]['rak_id'] = $getrak->id;
                    $transLog[$i]['branch_code'] = $purchase->branch_code;
                    $transLog[$i]['branch_id'] = $purchase->branch_id;
                }    
            }
            $purchase->tqty = $tqty;
            // dd($transLog)       ;
            if($setStatus){
                $result = $this->Purchases->save($purchase,[ 'associated' => ['PurchaseDetails']]);
                if ($result) {
                    
                    // Simpan data ke part_price_history
                foreach ($purchase->purchase_details as $detail) {
                    $this->addPurchaseDetail(
                        $detail->partnumber, // partnumber
                        $detail->qty,        // qty
                        $detail->total,      // total
                        $purchase->created   // created (gunakan tanggal pembelian)
                    );
                }
                    
                    //simpan jadi stok
                    
                    if($purchase->type_transaction == 'Reguler')
                    {    
                        if($transLog){
                            $logpartTable = $this->fetchTable('Transactions.LogParts');
                            $logs = $logpartTable->newEntities($transLog);
                            $resulLogs = $logpartTable->saveMany($logs);
                            if($resulLogs){
                             //update stok
                                $parttable = $this->fetchTable('Transactions.StockParts');
                                foreach ($transLog as $i => $v) {
                                  $getStocks = $parttable->find()->where(['partnumber'=>$v['part_no'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                                  //dd($v);
                                  if($getStocks){
                                        $getStocks->qty = $getStocks->qty + $v['qty']; 
                                  }else{
                                        $getStocks = $parttable->newEmptyEntity();
                                        $getStocks->partnumber = $v['part_no'];
                                        $getStocks->partdesc  = $v['part_name'];
                                        $getStocks->rak = $v['rak_code'];
                                        $getStocks->warehouse_code = $v['warehouse_code'];
                                        $getStocks->qty = $v['qty'];
                                        $getStocks->warehouse_id = $v['warehouse_id'];
                                        $getStocks->warehouse_name = 'Gudang 1 Jakarta';
                                        $getStocks->branch_code = $v['branch_code'];
                                        $getStocks->branch_id = $v['branch_id'];
                                        $getStocks->rak_id = '8c746abb-fde3-4af8-b39c-7c9730f32bbf';
                                        $getStocks->rak = 'RAKDEFAULT';
                                  }
                                  
                                  if(!$parttable->save($getStocks)){
                                        $setStatus = 0;
                                        $message = 'Fail update stocks. Please, try again.';
                                        break;
                                  }else{
                                        $setStatus = 1;
                                        $message = 'The data has been saved.';
                                  }
                                }
                            }else{
                                $setStatus = 0;
                                $message = 'The log parts could not be saved. Please, try again.';
                            }
                        }
                    }else{
                         $setStatus = 1;
                        $message = 'The data has been saved.';
                    }    
                          
                }else{
                  $setStatus = 0;
                  $message = 'The data Purchase could not be saved. Please, try again.';
                }
            }



            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }


        }

        $supplierTable = $this->fetchTable('Masters.Suppliers');
        $suppliers = $supplierTable
                    ->find('list',
                        keyField : 'supplier_code',
                        valueField : 'name'
                    )
                    ->toArray();

       
                            
        $this->set(compact('purchase','suppliers'));
        $this->set('_serialize', ['purchase']);            
    }
    public function getpartdetail(){
        $this->autoRender = false;
        $keyword = $this->request->getQuery('term');

        $parttable = $this->fetchTable('Masters.Parts');
        
        $suggestions = $parttable
            ->find()->where(['partnumber' => $keyword])
            ->first();

       
        echo json_encode($suggestions);
        exit;
    }
    function getSparepart($partnumber){
        // $warehouseTable = $this->fetchTable('Masters.Warehouses');
        // $getWarehouse = $warehouseTable->find()->where(['branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code')])->first();
        $parttable = $this->fetchTable('Masters.Parts');
        $getParts = $parttable->find()
                    ->where([
                            'partnumber'=>$partnumber,
                            // 'branch_code'=>$this->getRequest()->getSession()->read('Auth.branch_code'),
                            // 'warehouse_code'=>$getWarehouse->kode_gudang
                            ])
                        ->first();
        echo json_encode($getParts);
        exit;
    }

    function batal($id){
        $this->request->allowMethod(['post', 'delete']);
        $connection = ConnectionManager::get('default');
        $connection->begin();
        $data = $this->Purchases->get($id,
            contain : ['PurchaseDetails']
        );
        if($data->status == 1){
            $this->Flash->success(__('Faktur Pembelian  '.$data->purchase_code.' sudah dibatalkan sebelumnya.'));
            return $this->redirect(['action' => 'index']);
        }
        $data->status = 1;
        $update = $this->Purchases->save($data);
        if ($update) {
            //add log trans
            $logpartTable = $this->fetchTable('Transactions.LogParts');
            foreach($data->invoice_parts as $i=>$v){
                
                $entLog = $logpartTable->newEmptyEntity();

                $entLog->trx_code = $data->purchase_code;
                $entLog->trx_date = $data->purchase_date;
                $entLog->part_no = $v->partnumber;
                $entLog->part_name = $v->partdesc;
                $entLog->in_out = 'O';
                $entLog->qty = $v->qty;
                $entLog->warehouse_code = $v->warehouse_code;
                $entLog->warehouse_id = $v->warehouse_id;
                $entLog->rak_code = $v->rak_code;
                $entLog->rak_id = $v->rak_id;
                $entLog->branch_id = $v->branch_id;
                $entLog->branch_code = $v->branch_code;
                $resulLogs = $logpartTable->save($entLog);
                if(!$logpartTable->save($entLog)){
                   
                    $setStatus = 0;
                    $message = 'Fail add log partnumber. Please, try again.';
                }else{
                    
                      //update mst stok
                      $parttable = $this->fetchTable('Transactions.StockParts');
                      $getStocks = $parttable->find()->where(['partnumber'=>$v['partnumber'],'rak'=>$v['rak_code'],'warehouse_code'=>$v['warehouse_code']])->first();
                              //dd($v);
                      $getStocks->qty = $getStocks->qty - $v['qty']; 
                      if(!$parttable->save($getStocks)){
                            $setStatus = 0;
                            $message = 'Fail update stocks. Please, try again.';
                            break;
                      }else{
                            $setStatus = 1;
                            $message = 'The data has been saved.';
                      }
                }


            }
          
            $connection->commit();
            $this->Flash->success(__('Faktur Pembelian sudah dibatalkan.'));
        } else {
            $connection->rollback();
            $this->Flash->error(__('Faktur Pembelian  gagal dibatalkan. Silakan mencoba kembali.'));
        }

        return $this->redirect(['action' => 'index']);
    }

    public function view($id = null)
    {
        $data['titlePage'] = 'Faktur Pembelian';
        $data['titleMenu'] = 'View Data Faktur Pembelian';
        $purchase = $this->Purchases->get($id, contain: ['PurchaseDetails']);
        $this->set(compact('data','purchase'));
    }
    
    
   public function addPurchaseDetail($partnumber, $qty, $total, $created)
{
    $conn = ConnectionManager::get('default');
    $harga_per_qty = $total / $qty;

    // Format tanggal
    if ($created instanceof \Cake\I18n\DateTime) {
        $valid_from = $created->format('Y-m-d H:i:s');
        $purchase_created = $created->format('Y-m-d H:i:s');
    } elseif (is_string($created)) {
        $valid_from = date("Y-m-d H:i:s", strtotime($created));
        $purchase_created = date("Y-m-d H:i:s", strtotime($created));
    } else {
        $valid_from = date('Y-m-d H:i:s');
        $purchase_created = date('Y-m-d H:i:s');
        Log::write('warning', 'Nilai $created tidak valid. Menggunakan tanggal saat ini.');
    }

    try {
        // Cek apakah harga part sudah ada sebelumnya
        $existingPrice = $conn->execute("
            SELECT harga_beli, valid_from
            FROM part_price_history
            WHERE partnumber = :partnumber
            ORDER BY valid_from DESC
            LIMIT 1", ['partnumber' => $partnumber])->fetch('assoc');

        if ($existingPrice && $existingPrice['harga_beli'] != $harga_per_qty) {
            // Update data harga lama (tutup dengan valid_to)
            $conn->execute("
                UPDATE part_price_history
                SET valid_to = :valid_to
                WHERE partnumber = :partnumber AND valid_from = :valid_from",
                [
                    'valid_to' => $valid_from, // Gunakan tanggal valid_from yang baru sebagai valid_to untuk data lama
                    'partnumber' => $partnumber,
                    'valid_from' => $existingPrice['valid_from']
                ]
            );

             Log::write('debug', 'Harga partnumber: '. $partnumber .' di update valid_to nya menjadi: '. $valid_from);
        }

        // Insert data baru (harga yang baru)
        $conn->execute("
            INSERT INTO part_price_history (partnumber, harga_beli, valid_from, source, purchase_created)
            VALUES (:partnumber, :harga_beli, :valid_from, 'purchase_details', :purchase_created)",
            [
                'partnumber' => $partnumber,
                'harga_beli' => $harga_per_qty,
                'valid_from' => $valid_from,
                'purchase_created' => $purchase_created
            ]
        );

         Log::write('debug', 'Harga partnumber: '. $partnumber .' di input dengan valid_from: '. $valid_from);

    } catch (\Exception $e) {
        Log::write('error', 'Gagal menyimpan data ke part_price_history: ' . $e->getMessage());
        throw $e;
    }
}
}