<?php
/**
 * @var \App\View\AppView $this
 * @var array $partsList
 */
?>
<div class="content-body">
    <div class="container-fluid">
        <div class="row page-titles">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><?= $this->Html->link('Home', ['controller' => 'Home', 'action' => 'index']) ?></li>
                <li class="breadcrumb-item"><?= $this->Html->link('Report', ['action' => 'index']) ?></li>
                <li class="breadcrumb-item active">Kartu Stock</li>
            </ol>
        </div>

        <div class="row">
            <div class="col-12">
                <?= $this->Flash->render() ?>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">Filter Laporan Kartu Stok</h4>
                    </div>
                    <?= $this->Form->create(null, ['url' => ['action' => 'index']]) ?>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Periode</label>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <?= $this->Form->control('month', [
                                                'label' => false,
                                                'class' => 'form-control',
                                                'options' => [
                                                    '01' => 'Januari', '02' => 'Februari', '03' => 'Maret',
                                                    '04' => 'April', '05' => 'Mei', '06' => 'Juni',
                                                    '07' => 'Juli', '08' => 'Agustus', '09' => 'September',
                                                    '10' => 'Oktober', '11' => 'November', '12' => 'Desember'
                                                ],
                                                'default' => date('m')
                                            ]) ?>
                                        </div>
                                        <div class="col-md-6">
                                            <?= $this->Form->control('year', [
                                                'label' => false,
                                                'class' => 'form-control',
                                                'options' => [
                                                    '2022' => '2022', '2023' => '2023', '2024' => '2024'
                                                ],
                                                'default' => date('Y')
                                            ]) ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Part Number</label>
                                    <?= $this->Form->control('partnumber', [
                                        'label' => false,
                                        'class' => 'form-control select2',
                                        'empty' => '-- Pilih Part Number --',
                                        'options' => array_column($partsList, 'description', 'partnumber'),
                                        'required' => true
                                    ]) ?>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row mt-3">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label>Format Laporan</label>
                                    <div class="mt-2">
                                        <div class="form-check form-check-inline">
                                            <?= $this->Form->radio('type', [
                                                'html' => 'HTML',
                                            ], [
                                                'value' => 'html',
                                                'label' => false,
                                                'class' => 'form-check-input'
                                            ]) ?>
                                            <label class="form-check-label">HTML</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <?= $this->Form->radio('type', [
                                                'excel' => 'Excel'
                                            ], [
                                                'label' => false,
                                                'class' => 'form-check-input'
                                            ]) ?>
                                            <label class="form-check-label">Excel</label>
                                        </div>
                                        <div class="form-check form-check-inline">
                                            <?= $this->Form->radio('type', [
                                                'pdf' => 'PDF'
                                            ], [
                                                'label' => false,
                                                'class' => 'form-check-input'
                                            ]) ?>
                                            <label class="form-check-label">PDF</label>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <div class="text-end">
                            <?= $this->Form->button('<i class="fas fa-file-export"></i> Generate Report', [
                                'class' => 'btn btn-primary',
                                'escape' => false
                            ]) ?>
                        </div>
                    </div>
                    <?= $this->Form->end() ?>
                </div>
            </div>
        </div>

        <?php if (isset($data) && !empty($data)): ?>
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h4 class="card-title">
                            Kartu Stok - <?= $partInfo['partnumber'] ?> - <?= $partInfo['description'] ?>
                            <small class="text-muted">(Periode: <?= date('F Y', strtotime($periode . '-01')) ?>)</small>
                        </h4>
                        <div class="card-tools">
                            <button class="btn btn-sm btn-info" onclick="window.print()">
                                <i class="fas fa-print"></i> Print
                            </button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row mb-4">
                            <div class="col-md-3">
                                <div class="info-box bg-info">
                                    <span class="info-box-icon"><i class="fas fa-boxes"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Stok Minimum</span>
                                        <span class="info-box-number"><?= $partInfo['min_stock'] ?? 'N/A' ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box bg-success">
                                    <span class="info-box-icon"><i class="fas fa-arrow-down"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Masuk</span>
                                        <span class="info-box-number">
                                            <?= array_sum(array_map(function($item) {
                                                return ($item['in_out'] == 'I') ? $item['qty'] : 0;
                                            }, $data)) ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box bg-danger">
                                    <span class="info-box-icon"><i class="fas fa-arrow-up"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Total Keluar</span>
                                        <span class="info-box-number">
                                            <?= array_sum(array_map(function($item) {
                                                return ($item['in_out'] == 'O') ? $item['qty'] : 0;
                                            }, $data)) ?>
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="info-box bg-primary">
                                    <span class="info-box-icon"><i class="fas fa-box"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">Stok Akhir</span>
                                        <span class="info-box-number"><?= end($data)['saldo'] ?? 0 ?></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="table-responsive">
                            <table class="table table-bordered table-striped table-hover">
                                <thead class="thead-light">
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>No. Transaksi</th>
                                        <th>Jenis Transaksi</th>
                                        <th>Keterangan</th>
                                        <th class="text-center">Masuk</th>
                                        <th class="text-center">Keluar</th>
                                        <th class="text-center">Saldo</th>
                                        <th>Gudang</th>
                                        <th>Rak</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($data as $item): ?>
                                    <tr>
                                        <td><?= date('d/m/Y', strtotime($item['trx_date'])) ?></td>
                                        <td><?= h($item['trx_code']) ?></td>
                                        <td><?= h($item['transaction_type']) ?></td>
                                        <td><?= h($this->getTransactionDescription($item['trx_code'], $item['transaction_type'])) ?></td>
                                        <td class="text-center text-success">
                                            <?= (($item['in_out'] == 'I' || $item['in_out'] == 'SALDO_AWAL') ? $item['qty'] : '-') ?>
                                        </td>
                                        <td class="text-center text-danger">
                                            <?= ($item['in_out'] == 'O' ? $item['qty'] : '-') ?>
                                        </td>
                                        <td class="text-center font-weight-bold"><?= $item['saldo'] ?></td>
                                        <td><?= h($item['warehouse_code']) ?></td>
                                        <td><?= h($item['rak_code']) ?></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif; ?>
    </div>
</div>

<?php $this->append('css'); ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    .info-box {
        display: flex;
        align-items: center;
        padding: 15px;
        border-radius: 5px;
        color: white;
        margin-bottom: 15px;
    }
    .info-box-icon {
        font-size: 24px;
        padding-right: 15px;
    }
    .info-box-content {
        flex: 1;
    }
    .info-box-text {
        font-size: 14px;
        text-transform: uppercase;
    }
    .info-box-number {
        font-size: 18px;
        font-weight: bold;
    }
    .select2-container--default .select2-selection--single {
        height: 38px;
        padding: 5px 10px;
    }
</style>
<?php $this->end(); ?>

<?php $this->append('script'); ?>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    $('.select2').select2({
        placeholder: "Pilih Part Number",
        allowClear: true
    });
});
</script>
<?php $this->end(); ?>