<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Style\Font;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ReportTopSalesController extends AppController
{
    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Top Sales';
        $data['titleMenu'] = 'Top Sales Part';

        if ($this->request->is('post')) {
           $start = $this->request->getData('start');
        $end = $this->request->getData('end') . ' 23:59:59';
        
        $result = $conn->execute("
            SELECT partnumber, partdesc, SUM(qty) AS total_qty, SUM(total_harga) AS total_sales
            FROM workshops_dtlparts
            WHERE created BETWEEN :start AND :end AND status = '0'
            GROUP BY partnumber, partdesc
            ORDER BY total_qty DESC
        ", ['start' => $start, 'end' => $end])->fetchAll('assoc');

            if (empty($result)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            $this->set(compact('data', 'periode', 'result'));

            switch ($this->request->getData('type')) {
                case 'html':
                    $this->render('index');
                    break;
                case 'excel':
                    return $this->generateExcel($result, $periode);
                case 'pdf':
                    $this->render('pdf');
                    break;
                default:
                    $this->render('index');
                    break;
            }
        }

        $this->set(compact('data'));
    }

    private function generateExcel($data, $periode)
    {
        $spreadsheet = new Spreadsheet();
        $sheet = $spreadsheet->getActiveSheet();

        // Set document properties
        $spreadsheet->getProperties()
            ->setCreator('Your Company Name')
            ->setTitle('Report Top Sales')
            ->setDescription('Generated report for top sales');

        // Set header
        $sheet->setCellValue('A1', 'Report Top Sales')
              ->setCellValue('A2', 'Periode: ' . $periode);
        $sheet->mergeCells('A1:D1');
        $sheet->mergeCells('A2:D2');
        $sheet->getStyle('A1:A2')->getFont()->setBold(true)->setSize(12);
        $sheet->getStyle('A1:A2')->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);

        $row = 4;
        // Table headers
        $sheet->setCellValue('A'.$row, 'Part Number')
              ->setCellValue('B'.$row, 'Part Description')
              ->setCellValue('C'.$row, 'Total Qty')
              ->setCellValue('D'.$row, 'Total Sales');

        $sheet->getStyle('A'.$row.':D'.$row)->getFont()->setBold(true);
        $sheet->getStyle('A'.$row.':D'.$row)->getAlignment()->setHorizontal(Alignment::HORIZONTAL_CENTER);
        $sheet->getStyle('A'.$row.':D'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);
        $sheet->getStyle('A'.$row.':D'.$row)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setARGB('FFD3D3D3');

        $row++;
        // Fill data
        foreach ($data as $item) {
            $sheet->setCellValue('A' . $row, $item['partnumber'])
                  ->setCellValue('B' . $row, $item['partdesc'])
                  ->setCellValue('C' . $row, $item['total_qty'])
                  ->setCellValue('D' . $row, $item['total_sales']);

            $sheet->getStyle('D'.$row)->getNumberFormat()->setFormatCode(NumberFormat::FORMAT_NUMBER_COMMA_SEPARATED1);
            $sheet->getStyle('A'.$row.':D'.$row)->getBorders()->getAllBorders()->setBorderStyle(Border::BORDER_THIN);

            $row++;
        }

        // Apply autosize to all columns
        foreach (range('A', 'D') as $columnID) {
            $sheet->getColumnDimension($columnID)->setAutoSize(true);
        }

        // Output to browser
        $writer = new Xlsx($spreadsheet);
        $filename = 'Report_Top_Sales_' . date('Ymd_His') . '.xlsx';

        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment; filename="'. urlencode($filename) .'"');
        header('Cache-Control: max-age=0');

        $writer->save('php://output');
        exit;
    }
}
