<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use DateTime;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportPenjualanPartsController extends AppController
{
    public $PhpExcel = null;

    public function index()
    {
        $conn = ConnectionManager::get('default');
        $data['titlePage'] = 'Report Penjualan Part';
        $data['titleMenu'] = 'Report Penjualan Part';

        if ($this->request->is('post')) {
            $start = $this->request->getData('start');
            $end = $this->request->getData('end');

            // Validasi input tanggal
            if (!$start || !$end || !strtotime($start) || !strtotime($end)) {
                $this->Flash->error(__('Tanggal tidak valid.'));
                return $this->redirect(['action' => 'index']);
            }

            try {
                // [1] QUERY DATA PENJUALAN PART
                $result = $conn->execute("
                    SELECT a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, e.employee_code, 
                           c.partnumber, c.partdesc, sub.total_qty, 
                           (c.price * sub.total_qty * (1 - (c.diskon/100))) AS total_sales, 
                           c.total_harga, c.price, c.diskon, c.created
                    FROM workshops a 
                    LEFT JOIN (
                        SELECT workshop_id, partnumber, SUM(qty) as total_qty
                        FROM workshops_dtlparts
                        GROUP BY workshop_id, partnumber
                    ) sub ON a.id = sub.workshop_id
                    LEFT JOIN workshops_dtlparts c ON a.id = c.workshop_id AND sub.partnumber = c.partnumber
                    LEFT JOIN purchase_details pd ON c.partnumber = pd.partnumber
                    LEFT JOIN mst_employes e ON a.mekanik = e.employee_code
                    WHERE a.trans_date >= :start AND a.trans_date <= :end 
                        AND a.status != '1' 
                        AND c.status != '1'
                    GROUP BY a.trans_date, a.kode_workshop, a.nopol, e.nama_mekanik, e.employee_code, 
                             c.partnumber, c.partdesc, sub.total_qty, c.total_harga, c.price, c.diskon, c.created
                    ORDER BY a.trans_date ASC", ['start' => $start, 'end' => $end])->fetchAll('assoc');

                // [2] QUERY PENDAPATAN JASA SERVICE
                $pendapatanJasa = $conn->execute("
                    SELECT e.employee_code, e.nama_mekanik, SUM(b.total_harga - b.diskon) AS jasa
                    FROM workshops a 
                    JOIN workshops_dtlservices b ON a.id = b.workshop_id
                    JOIN mst_employes e ON a.mekanik = e.employee_code
                    WHERE trans_date BETWEEN :start AND :end 
                        AND a.status != '1' 
                        AND b.status != '1'
                    GROUP BY e.employee_code, e.nama_mekanik
                ", ['start' => $start, 'end' => $end])->fetchAll('assoc');

                // [3] HITUNG HPP & PROFIT PART
                foreach ($result as &$item) {
                    $partnumber = $item['partnumber'];
                    $transDate = $item['trans_date'];

                    $hpp = $conn->execute("
                        SELECT h.harga_beli
                        FROM part_price_history h
                        WHERE h.partnumber = :partnumber
                          AND h.valid_from <= :trans_date
                          AND (h.valid_to IS NULL OR h.valid_to >= :trans_date)
                        ORDER BY h.valid_from DESC
                        LIMIT 1", ['partnumber' => $partnumber, 'trans_date' => $transDate])->fetch('assoc');

                    $item['total_hpp'] = $item['total_qty'] * ($hpp['harga_beli'] ?? 0);
                    $item['profit'] = $item['total_sales'] - $item['total_hpp'];
                }

                // [4] HITUNG OMZET & PROFIT PER MEKANIK
                $profitPerMekanik = [];
                
                // --- A. PROSES DATA PART ---
                foreach ($result as $item) {
                    $empCode = $item['employee_code'];
                    
                    if (!isset($profitPerMekanik[$empCode])) {
                        $profitPerMekanik[$empCode] = [
                            'nama_mekanik' => $item['nama_mekanik'],
                            'omzet_part' => 0,
                            'profit_part' => 0,
                            'omzet_jasa' => 0,
                            'profit_jasa' => 0
                        ];
                    }
                    
                    $profitPerMekanik[$empCode]['omzet_part'] += $item['total_sales'];
                    $profitPerMekanik[$empCode]['profit_part'] += $item['profit'];
                }
                
                // --- B. PROSES DATA JASA ---
                foreach ($pendapatanJasa as $jasa) {
                    $empCode = $jasa['employee_code'];
                    
                    if (!isset($profitPerMekanik[$empCode])) {
                        $profitPerMekanik[$empCode] = [
                            'nama_mekanik' => $jasa['nama_mekanik'],
                            'omzet_part' => 0,
                            'profit_part' => 0,
                            'omzet_jasa' => 0,
                            'profit_jasa' => 0
                        ];
                    }
                    
                    // Asumsi profit jasa = omzet jasa (jika tidak ada biaya)
                    $profitPerMekanik[$empCode]['omzet_jasa'] += $jasa['jasa'];
                    $profitPerMekanik[$empCode]['profit_jasa'] += $jasa['jasa'];
                }
                
                // --- C. HITUNG TOTAL ---
                foreach ($profitPerMekanik as &$mekanik) {
                    $mekanik['total_omzet'] = $mekanik['omzet_part'] + $mekanik['omzet_jasa'];
                    $mekanik['total_profit'] = $mekanik['profit_part'] + $mekanik['profit_jasa'];
                }

                // [5] HITUNG TOTAL KESELURUHAN
                $totalOmzetPart = array_sum(array_column($result, 'total_sales'));
                $totalOmzetJasa = array_sum(array_column($pendapatanJasa, 'jasa'));
                $totalOmzet = $totalOmzetPart + $totalOmzetJasa;
                $totalProfitPart = array_sum(array_column($result, 'profit'));
                $totalProfitJasa = array_sum(array_column($pendapatanJasa, 'jasa'));
                $totalProfit = $totalProfitPart + $totalProfitJasa;

            } catch (\Exception $e) {
                $this->Flash->error(__('Terjadi kesalahan saat mengambil data: ' . $e->getMessage()));
                return $this->redirect(['action' => 'index']);
            }

            if (empty($result) && empty($pendapatanJasa)) {
                $this->Flash->set(__('Data tidak tersedia.'));
                return $this->redirect(['action' => 'index']);
            }

            $company = [
                'name' => 'AHASS RAJAWALI PUTERA',
                'address' => '-'
            ];

            $periode = date("d F Y", strtotime($start)) . ' - ' . date("d F Y", strtotime($end));
            
            $this->set(compact(
                'data', 
                'periode', 
                'company', 
                'result', 
                'profitPerMekanik',
                'totalOmzetPart',
                'totalOmzetJasa',
                'totalOmzet',
                'totalProfitPart', 
                'totalProfitJasa', 
                'totalProfit'
            ));

            switch ($this->request->getData('type')) {
                case 'excel':
                    $file = 'excel';
                    break;
                case 'pdf':
                    $file = 'pdf';
                    break;
                default:
                    $file = 'html';
                    break;
            }

            $this->render($file);
        }

        $this->set(compact('data'));
    }
}