<?php

declare(strict_types=1);


namespace Reports\Controller;


use App\Controller\AppController;

use Cake\Database\Expression\QueryExpression;


class ReportPelangganBarusController extends AppController

{

    public function index()

    {

        $data['titlePage'] = 'Laporan Pelanggan Baru';

        $data['titleMenu'] = 'Laporan Pelanggan Baru';


         $startDate = null;

        $endDate = null;

        $monthInput = null;

        $filterType = null;


        if ($this->request->is('get')) { // Handle Filter Tanggal (GET)

            $startDateInput = $this->request->getQuery('start_date');

            $endDateInput = $this->request->getQuery('end_date');


            if (!empty($startDateInput) && !empty($endDateInput)) {

                $startDate = date('Y-m-d', strtotime($startDateInput));

                $endDate = date('Y-m-d', strtotime($endDateInput));


                if (!$startDate || !$endDate) {

                    $this->Flash->error(__('Format tanggal tidak valid (YYYY-MM-DD).'));

                    return $this->redirect(['action' => 'index']);

                }

                if (strtotime($startDate) > strtotime($endDate)) {

                    $this->Flash->error(__('Tanggal mulai tidak boleh setelah tanggal selesai.'));

                    return $this->redirect(['action' => 'index']);

                }

                $filterType = 'date';

            }

        } elseif ($this->request->is('post')) { // Handle Filter Bulan (POST)

            $monthInput = $this->request->getData('month');

            if (empty($monthInput)) {

                $this->Flash->error(__('Silakan pilih bulan dan tahun.'));

                return $this->redirect(['action' => 'index']);

            }

            $startDate = date('Y-m-01', strtotime($monthInput));

            $endDate = date('Y-m-t', strtotime($monthInput));

            $filterType = 'month';

        }


        // Query Database (Hanya dijalankan jika ada filter yang diterapkan)

        if (!empty($startDate) && !empty($endDate)) {

            $dataTable = $this->fetchTable('Transactions.Invoices');


            $existingCustomers = $dataTable->find();

            $existingCustomers->select(['nopol'])

                ->where(function (QueryExpression $exp) use ($startDate) {

                    return $exp->lt('trans_date', $startDate);

                })

                ->distinct(['nopol']);


            $query = $dataTable->find();

            $query->select([

                'trans_date',

                'nopol',

                'type_mtr'

            ])

            ->where(function (QueryExpression $exp) use ($startDate, $endDate, $existingCustomers) {

                $exp->between('trans_date', $startDate, $endDate);

                $exp->notIn('nopol', $existingCustomers);

                return $exp;

            })

                ->distinct(['nopol'])

                ->order(['trans_date' => 'ASC']);


            $result = $query->all();

                $company['name'] = $this->getRequest()->getSession()->read('Auth.company_name');

                $company['address'] = $this->getRequest()->getSession()->read('Auth.company_address');


                if ($result->isEmpty()) {

                    $this->Flash->set(__('Data tidak tersedia.'));

                    if ($this->request->is('post')) {

                        return $this->redirect(['action' => 'index']);

                    }

                }


                $periode = date('d/m/Y', strtotime($startDate)) . ' - ' . date('d/m/Y', strtotime($endDate)); // Mempertahankan format tanggal yang ada


                $type = $this->request->getData('type') ?? 'html';


                if ($type === 'excel') {

                    $this->viewBuilder()->setClassName('Cake\View\View');

                    $this->set(compact('result', 'company', 'periode'));

                    $this->response = $this->response->withType('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');

                    $this->response = $this->response->withHeader('Content-Disposition', 'attachment;filename="LaporanPelangganBaru.xlsx"');

                    return $this->render('excel');

                } else {


                   /* $breadcrumbs = [

                        ['title' => 'Dashboard', 'url' => '/'],

                        ['title' => 'Laporan', 'url' => ['plugin' => null, 'controller' => 'Reports', 'action' => 'index']],

                        ['title' => 'Laporan Pelanggan Baru', 'url' => ['action' => 'index']]

                    ];*/

                    $this->set(compact('result', 'data', 'periode', 'company', 'startDate', 'endDate', 'monthInput', 'filterType'));

                    $this->render($type);

                }

            

            }

        }

    } 