<?php
namespace Reports\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
use PHPExcel;
use PHPExcel_IOFactory;
use Setasign\Fpdf;

class ReportCogsController extends AppController
{

    public $PhpExcel = null;

    public function index()
    {
        ini_set('memory_limit', '-1');
        ini_set('max_execution_time', 0); 
        $conn = ConnectionManager::get('default');
        if ($this->request->is('post')) {
          $this->loadModel('Transactions.Pkbs');
          if(date('d')>=26  ){
            $periodeSawal = date('Y-m',strtotime($this->request->getData('periode')['year'].'-'.$this->request->getData('periode')['month'].'-01 +1 month'));
          }else{
            $periodeSawal = $this->request->getData('periode')['year'].'-'.$this->request->getData('periode')['month'];  
          }
           $periode = $this->request->getData('periode')['year'].'-'.$this->request->getData('periode')['month']; 
          $datas =$conn->execute("
             select a.partnumber,b.deskripsi deskripsi, sum(qSA) qSA, sum(aSA) aSA,sum(qBeli) qBeli, sum(round(aBeli)) aBeli,sum(qRetJ) qRetJ, sum(aRetJ) aRetJ,sum(qJual) qJual,  sum(aJual) aJual, sum(qRetBeli) qRetBeli, sum(aRetBeli) aRetBeli,  ( sum(qSA) + sum(qBeli) + sum(qRetJ) - sum(qJual) - sum(qRetBeli) ) qSaldoAkhir, 
             ( sum(aSA) + sum(aBeli) + sum(aRetJ) - sum(aJual) - sum(aRetBeli) ) aSaldoAkhir ,
             round (( sum(aSA) + sum(aBeli) + sum(aRetJ) - sum(aJual) - sum(aRetBeli) )  /    ( sum(qSA) + sum(qBeli) + sum(qRetJ) - sum(qJual) - sum(qRetBeli) )) aHargaSatuan, round( sum(aSA) + sum(aBeli) - sum(aRetBeli)) / (sum(qSA) + sum(qBeli) - sum(qRetBeli))  ahpp,
             b.harga as het

                from (
                select partnumber, sum(qty) qSA, (sum(harga) * sum(qty)) aSA, 0 qBeli, 0 aBeli,0 qRetJ, 0 aRetJ, 0 qJual, 0 aJual, 0 qRetBeli,0 aRetBeli 
                    from saldo_cogs 
                  where periode='$periodeSawal'
                  group by partnumber
                  
                  UNION ALL
                  select partnumber, 0 qSA, 0 aSA, sum(qty) qBeli, sum(round(a.total)) aBeli,0 qRetJ, 0 aRetJ, 0 qJual, 0 aJual, 0 qRetBeli,0 aRetBeli 
                    from purchase_details a join purchases b on a.purchase_id=b.id
                  where date_format(b.purchase_date,'%Y-%m')='$periode'
                  group by partnumber
                  
                  UNION ALL
                  select partnumber, 0 qSA, 0 aSA, 0 qBeli, 0 aBeli,sum(qty) qRetJ, sum(a.net_price) aRetJ, 0 qJual, 0 aJual, 0 qRetBeli,0 aRetBeli
                    from return_directsales_details a join return_directsales b on a.ret_id=b.id
                  where date_format(b.ret_date,'%Y-%m')='$periode'
                  group by partnumber
                  UNION ALL
                  select trans_code, 0 qSA, 0 aSA, 0 qBeli, 0 aBeli,0 qRetJ, 0 aRetJ, sum(qty) qJual,  sum(a.total) aJual, 0 qRetBeli,0 aRetBeli 
                    from payreceipt_details a join payreceipts b on a.payreceipt_id=b.id
                  where date_format(b.payreceipt_date,'%Y-%m')='$periode'
                  group by trans_code
                  
                  UNION ALL
                  select partnumber, 0 qSA, 0 aSA, 0 qBeli, 0 aBeli,0 qRetJ, 0 aRetJ, sum(qty) qJual,  sum(a.net_price) aJual, 0 qRetBeli,0 aRetBeli 
                    from directsales_details a join direct_sales b on a.directsales_id=b.id
                  where date_format(b.directsales_date,'%Y-%m')='$periode'
                  group by partnumber
                  ) a
                   join mst_parts b on a.partnumber=b.partnumber
                  group by partnumber
      
                    order by partnumber asc
            ");
          $data = $datas->fetchAll('assoc');  
         //dd($data);
          if(empty($data)){
            $this->Flash->set(__('Data tidak tersedia.'));
            return $this->redirect(['action' => 'index']);
          } 
          switch ($this->request->data('type')) {
            case 'html':
              $file = 'html';
              break;
            case 'excel':
              $file = 'excel';
              break;
            case 'pdf':
              $file = 'pdf';
              break;
            default:
              $file = 'html';
              break;
          }
          $periode = date("d F Y",strtotime($periode.'-01'));
          $this->set(compact('data','periode','datas'));
          $this->render($file);
        }
    }

}
