<?php
namespace Masters\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;


class CorporatesTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('mst_perusahaan');

        $this->addBehavior('Timestamp');

    }

   /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {

        $validator
            ->scalar('name')
            ->requirePresence('name', 'create')
            ->allowEmptyString('name', 'Nama harus diisi', false)    
       ;
       $validator
            ->scalar('discount_part')
            ->requirePresence('discount_part', 'create')
            ->allowEmptyString('discount_part', 'Diskon part harus diisi', false)    
       ;

       $validator
            ->scalar('discount_jasa')
            ->requirePresence('discount_jasa', 'create')
            ->allowEmptyString('discount_jasa', 'Diskon jasa harus diisi', false)    
       ;


        return $validator;
    }



}
