<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
/**
 * Suppliers Controller
 *
 * @property \Masters\Model\Table\CustomersTable $Suppliers
 *
 * @method \Masters\Model\Entity\Customer[] paginate($object = null, array $settings = [])
 */
class SuppliersController extends AppController
{

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Supplier';
        $data['titleMenu'] = 'Data Supplier';


        $query = $this->Suppliers->find('all');
        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'supplier_code LIKE' => '%' . $search . '%',
                    'name LIKE' => '%' . $search . '%',
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Suppliers.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Suppliers.created desc');
        
        $suppliers = $this->paginate($query);


        
      $this->set(compact('suppliers','data'));
      $this->set('_serialize', ['suppliers']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $supplier = $this->Suppliers->get($id);

        $this->set('supplier', $supplier);
        $this->set('_serialize', ['supplier']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Supplier';
        $data['titleMenu'] = 'Data Supplier';
        //$this->loadComponent('General');
        $setStatus = 1;
        $supplier = $this->Suppliers->newEmptyEntity();
        if ($this->request->is('post')) {

            $connection = ConnectionManager::get('default');
            $connection->begin();
            $supplier = $this->Suppliers->patchEntity($supplier, $this->request->getData());

            $supplier->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $supplier->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Suppliers->save($supplier)) {
                $setStatus = 1;
                $message = 'The supplier has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The supplier could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }


        $this->set(compact('supplier','data'));
        $this->set('_serialize', ['supplier']);
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Supplier';
        $data['titleMenu'] = 'Data Supplier';
        $supplier = $this->Suppliers->get($id);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $supplier = $this->Suppliers->patchEntity($supplier, $this->request->getData());
            $supplier->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $supplier->modi_by = $this->getRequest()->getSession()->read('Auth.id');
			//dd($supplier);
            if ($this->Suppliers->save($supplier)) {
                $setStatus = 1;
                $message = 'The supplier has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The supplier could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }

        $this->set(compact('supplier','data'));
        $this->set('_serialize', ['supplier']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
     public function delete($id = null)
     {
         $this->request->allowMethod(['post', 'delete']);
         $connection = ConnectionManager::get('default');
         $connection->begin();
         if(isset($this->request->data['id'])){
             $ids = explode(',',$this->request->data['id']);
         }else $ids = [$id];

         foreach($ids as $i=>$v){
           $supplier = $this->Suppliers->get($v);
           if ($this->Suppliers->delete($supplier,[
             'dependent' => true,
             'cascadeCallbacks' => true
             ])) {
               $setStatus=1;
               $message = 'The supplier has been deleted.';
           } else {
               $setStatus=0;
               $message = 'The supplier with id: '.$v.' could not be deleted. Please, try again.';
               break;
           }
         }

         $this->Flash->error(__($message));
         if($setStatus){
             $connection->commit();
         }else {
             $connection->rollback();
         }
         return $this->redirect(['action' => 'index']);
     }
}
