<?php
namespace Masters\Controller;

use App\Controller\AppController;
use Cake\Datasource\ConnectionManager;
 
class RaksController extends AppController
{
    public function beforeFilter(\Cake\Event\EventInterface $event)
    {
        parent::beforeFilter($event);
    }

    /**
     * Index method
     *
     * @return \Cake\Http\Response|void
     */
    public function index()
    {
        $data['titlePage'] = 'Master Rak';
        $data['titleMenu'] = 'Master Rak';
		
        $query = $this->Raks->find('all');
        if ($this->request->getQuery('search')) {
            $search = $this->request->getQuery('search');
            $query->where([
                'OR' => [
                    'rak_code LIKE' => '%' . $search . '%',
                    'warehouse_code LIKE' => '%' . $search . '%',
                    'branch_code LIKE' => '%' . $search . '%'
                ]
            ]);
        }


        if($this->request->getQuery('sort') and $this->request->getQuery('direction')){
             $query = $query->order('Raks.'.$this->request->getQuery('sort').' '.$this->request->getQuery('direction'));
        }else $query = $query->order('Raks.created desc');
        
        $raks = $this->paginate($query);


        

		//dd($getCookieCust);
		$this->set(compact('raks','data'));
		$this->set('_serialize', ['raks']);
    }

    /**
     * View method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|void
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $data['titlePage'] = 'Master Rak';
        $data['titleMenu'] = 'Data Rak';
        $rak = $this->Raks->get($id);

        $this->set(compact('rak','data' ));
        $this->set('_serialize', ['rak']);
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $data['titlePage'] = 'Master Rak';
        $data['titleMenu'] = 'Data Rak';
        $rak = $this->Raks->newEmptyEntity();
        if ($this->request->is('post')) {
            $rak = $this->Raks->patchEntity($rak, $this->request->getData());
            $rak->create_by = $this->getRequest()->getSession()->read('Auth.id');
            $rak->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Raks->save($rak)) {
                $this->Flash->success(__('The rak has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The rak could not be saved. Please, try again.'));
        }
        $warehouseModel = $this->fetchTable('Masters.Warehouses');
        $warehouse = $warehouseModel
                    ->find('list',
                        keyField : 'rak_code',
                        valueField : 'rak_code'
                    )
                    ->toArray();
        $this->set(compact('rak','data','warehouse'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Network\Exception\NotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $data['titlePage'] = 'Master Rak';
        $data['titleMenu'] = 'Data Rak';
        $rak = $this->Raks->get($id, [
            'contain' => []
        ]);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $connection = ConnectionManager::get('default');
            $connection->begin();
            $rak = $this->Raks->patchEntity($rak, $this->request->getData());
            
            $rak->modi_by = $this->getRequest()->getSession()->read('Auth.id');
            if ($this->Raks->save($rak)) {
                $setStatus = 1;
                $message = 'The rak has been saved.';
            }else{
                $setStatus = 0;
                $message = 'The rak could not be saved. Please, try again.';
            }

            $this->Flash->set(__($message));

            if($setStatus){
                $connection->commit();
                return $this->redirect(['action' => 'index']);
            }else {
                $connection->rollback();
            }
        }
        $warehouseModel = $this->fetchTable('Masters.Warehouses');
        $warehouse = $warehouseModel
                    ->find('list',
                        keyField : 'kode_gudang',
                        valueField : 'nama_gudang'
                    )
                    ->toArray();
        
        $this->set(compact('rak','data','warehouse'));
        $this->set('_serialize', ['rak']);
    }

    /**
     * Delete method
     *
     * @param string|null $id Customer id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $rak = $this->Raks->get($id);
        if ($this->Raks->delete($rak)) {
            $this->Flash->success(__('The rak has been deleted.'));
        } else {
            $this->Flash->error(__('The rak could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }


    function getraksdetail($partnumber){
        $this->viewBuilder()->setLayout(false);
        $data = $this->Raks
                    ->find('list',
                        keyField : 'rak_code',
                        valueField : 'rak_code'
                    )
                    ->toArray();

        // Create a JSON response
        $this->response = $this->response->withType('application/json')
                                         ->withStringBody(json_encode($data));

        // Return the response
        return $this->response;
    }
   
}
